/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.bayeux;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class BinaryData
extends HashMap<String, Object> {
    public static final String EXT_NAME = "binary";
    public static final String META = "meta";
    public static final String DATA = "data";
    public static final String LAST = "last";

    public BinaryData(ByteBuffer byteBuffer, boolean last, Map<String, Object> metaData) {
        super(4);
        this.put(DATA, byteBuffer);
        this.put(LAST, last);
        if (metaData != null) {
            this.put(META, metaData);
        }
    }

    public BinaryData(byte[] bytes, boolean last, Map<String, Object> metaData) {
        super(4);
        this.put(DATA, bytes);
        this.put(LAST, last);
        if (metaData != null) {
            this.put(META, metaData);
        }
    }

    public BinaryData(Map<? extends String, ?> map) {
        super(map);
    }

    public ByteBuffer asByteBuffer() {
        Object data = this.get(DATA);
        if (data instanceof ByteBuffer) {
            return ((ByteBuffer)data).slice();
        }
        if (data instanceof byte[]) {
            return ByteBuffer.wrap((byte[])data);
        }
        throw new IllegalArgumentException("Cannot convert to ByteBuffer: " + String.valueOf(data));
    }

    public byte[] asBytes() {
        Object data = this.get(DATA);
        if (data instanceof ByteBuffer) {
            ByteBuffer buffer = ((ByteBuffer)data).slice();
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            return bytes;
        }
        if (data instanceof byte[]) {
            return (byte[])data;
        }
        throw new IllegalArgumentException("Cannot convert to byte[]: " + String.valueOf(data));
    }

    public boolean isLast() {
        return (Boolean)this.get(LAST);
    }

    public Map<String, Object> getMetaData() {
        return (Map)this.get(META);
    }
}

