/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.web.filter;

import io.meeds.tenant.metamask.service.MetamaskLoginService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.JspBasedWebHandler;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.filter.Filter;
import org.exoplatform.web.security.security.RemindPasswordTokenService;

public class MetamaskSignInFilter
extends JspBasedWebHandler
implements Filter {
    public static final Log LOG = ExoLogger.getLogger(MetamaskSignInFilter.class);
    public static final String METAMASK_TENANT_SETUP_FORM = "/WEB-INF/jsp/metamaskSetupForm.jsp";
    public static final String METAMASK_AUTHENTICATED = "metamask.authenticated";
    public static final String SEPARATOR = "@";
    public static final String USERNAME_REQUEST_PARAM = "username";
    public static final String PASSWORD_REQUEST_PARAM = "password";
    public static final String INITIAL_URI_REQUEST_PARAM = "initialURI";
    public static final String METAMASK_SIGNED_MESSAGE_PREFIX = "SIGNED_MESSAGE@";
    private MetamaskLoginService metamaskLoginService;
    private WebAppController webAppController;
    private ServletContext servletContext;
    private RemindPasswordTokenService remindPasswordTokenService;

    public MetamaskSignInFilter(PortalContainer container, RemindPasswordTokenService remindPasswordTokenService, WebAppController webAppController, LocaleConfigService localeConfigService, BrandingService brandingService, JavascriptConfigService javascriptConfigService, SkinService skinService, MetamaskLoginService metamaskLoginService) {
        super(localeConfigService, brandingService, javascriptConfigService, skinService);
        this.remindPasswordTokenService = remindPasswordTokenService;
        this.webAppController = webAppController;
        this.metamaskLoginService = metamaskLoginService;
        this.servletContext = container.getPortalContext();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            if (this.isDeedTenantStep(request)) {
                this.forwardDeedTenantSetupForm(new ControllerContext(this.webAppController, this.webAppController.getRouter(), request, response, null));
                return;
            }
            String walletAddress = request.getParameter(USERNAME_REQUEST_PARAM);
            String password = request.getParameter(PASSWORD_REQUEST_PARAM);
            if (request.getRemoteUser() == null && StringUtils.isNotBlank((CharSequence)walletAddress) && StringUtils.startsWith((CharSequence)password, (CharSequence)METAMASK_SIGNED_MESSAGE_PREFIX)) {
                String username = this.metamaskLoginService.getUserWithWalletAddress(walletAddress);
                if (StringUtils.isBlank((CharSequence)username) && !this.metamaskLoginService.isAllowUserRegistration(walletAddress)) {
                    LOG.debug((Object)"Metamask registration isn't allowed");
                } else if (StringUtils.isBlank((CharSequence)username)) {
                    String signedMessage;
                    String rawMessage = this.metamaskLoginService.getLoginMessage(request.getSession());
                    boolean messageValidated = this.metamaskLoginService.validateSignedMessage(walletAddress, rawMessage, signedMessage = password.replace(METAMASK_SIGNED_MESSAGE_PREFIX, ""));
                    if (messageValidated) {
                        request.getSession().setAttribute(USERNAME_REQUEST_PARAM, (Object)walletAddress);
                        request.getSession().setAttribute(PASSWORD_REQUEST_PARAM, (Object)this.getCompoundPassword(request));
                        request.getSession().setAttribute("requireEmailValidation", (Object)"true");
                        String tokenId = this.remindPasswordTokenService.createToken(walletAddress, "external-registration");
                        String path = this.servletContext.getContextPath() + "/external-registration?token=" + tokenId;
                        if (this.metamaskLoginService.isDeedHub() && this.metamaskLoginService.isDeedManager(walletAddress)) {
                            path = path + "&initialURI=/portal/tenantSetup";
                        }
                        response.sendRedirect(path);
                        return;
                    }
                } else {
                    String compoundPassword = this.getCompoundPassword(request);
                    servletRequest = this.wrapRequestForLogin(request, username, compoundPassword, false);
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while registering user using metamask", (Throwable)e);
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    protected void forwardDeedTenantSetupForm(ControllerContext controllerContext) throws Exception {
        super.prepareDispatch(controllerContext, "SHARED/metamaskSetupForm", null, Collections.singletonList("portal/login"), null);
        this.servletContext.getRequestDispatcher(METAMASK_TENANT_SETUP_FORM).include((ServletRequest)controllerContext.getRequest(), (ServletResponse)controllerContext.getResponse());
    }

    private HttpServletRequestWrapper wrapRequestForLogin(HttpServletRequest request, final String username, final String password, final boolean redirectToSetup) {
        return new HttpServletRequestWrapper(this, request){

            public String getParameter(String name) {
                if (StringUtils.equals((CharSequence)name, (CharSequence)MetamaskSignInFilter.USERNAME_REQUEST_PARAM)) {
                    return username;
                }
                if (StringUtils.equals((CharSequence)name, (CharSequence)MetamaskSignInFilter.PASSWORD_REQUEST_PARAM)) {
                    return password;
                }
                if (redirectToSetup && StringUtils.equals((CharSequence)name, (CharSequence)MetamaskSignInFilter.INITIAL_URI_REQUEST_PARAM)) {
                    return this.getContextPath() + "/tenantSetup";
                }
                return super.getParameter(name);
            }

            public String getRequestURI() {
                return this.getContextPath() + "/login";
            }
        };
    }

    protected String getCompoundPassword(HttpServletRequest request) {
        String walletAddress = request.getParameter(USERNAME_REQUEST_PARAM);
        String password = request.getParameter(PASSWORD_REQUEST_PARAM);
        String rawMessage = this.metamaskLoginService.getLoginMessage(request.getSession());
        String signedMessage = password.replace(METAMASK_SIGNED_MESSAGE_PREFIX, "");
        return walletAddress + SEPARATOR + rawMessage + SEPARATOR + signedMessage;
    }

    private boolean isDeedTenantStep(HttpServletRequest request) {
        String walletAddress = request.getRemoteUser();
        return StringUtils.isNotBlank((CharSequence)walletAddress) && StringUtils.equals((CharSequence)request.getRequestURI(), (CharSequence)(request.getContextPath() + "/tenantSetup")) && this.metamaskLoginService.isDeedHub() && this.metamaskLoginService.isDeedManager(walletAddress);
    }
}

