/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.model;

import groovy.transform.ToString;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.exoplatform.perkstore.model.FileDetail;
import org.exoplatform.perkstore.model.PerkStoreCloneable;
import org.exoplatform.perkstore.model.Profile;
import org.exoplatform.perkstore.model.UserProductData;

@ToString
public class Product
extends PerkStoreCloneable
implements Serializable {
    private static final long serialVersionUID = 3182323147042158001L;
    private long id;
    private String title;
    private String description;
    private String illustrationURL;
    private Set<FileDetail> imageFiles;
    private boolean enabled;
    private boolean unlimited;
    private boolean allowFraction;
    private double totalSupply;
    private double price;
    private Profile receiverMarchand;
    private List<Profile> marchands;
    private List<Profile> accessPermissions;
    private String orderPeriodicity;
    private String orderPeriodicityLabel;
    private Profile creator;
    private Profile lastModifier;
    private double maxOrdersPerUser;
    private long createdDate;
    private long lastModifiedDate;
    private long notProcessedOrders;
    private double purchased;
    private UserProductData userData = new UserProductData();
    private boolean deleted;

    @Override
    public Product clone() {
        return (Product)super.clone();
    }

    public long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIllustrationURL() {
        return this.illustrationURL;
    }

    public Set<FileDetail> getImageFiles() {
        return this.imageFiles;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public boolean isAllowFraction() {
        return this.allowFraction;
    }

    public double getTotalSupply() {
        return this.totalSupply;
    }

    public double getPrice() {
        return this.price;
    }

    public Profile getReceiverMarchand() {
        return this.receiverMarchand;
    }

    public List<Profile> getMarchands() {
        return this.marchands;
    }

    public List<Profile> getAccessPermissions() {
        return this.accessPermissions;
    }

    public String getOrderPeriodicity() {
        return this.orderPeriodicity;
    }

    public String getOrderPeriodicityLabel() {
        return this.orderPeriodicityLabel;
    }

    public Profile getCreator() {
        return this.creator;
    }

    public Profile getLastModifier() {
        return this.lastModifier;
    }

    public double getMaxOrdersPerUser() {
        return this.maxOrdersPerUser;
    }

    public long getCreatedDate() {
        return this.createdDate;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public long getNotProcessedOrders() {
        return this.notProcessedOrders;
    }

    public double getPurchased() {
        return this.purchased;
    }

    public UserProductData getUserData() {
        return this.userData;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIllustrationURL(String illustrationURL) {
        this.illustrationURL = illustrationURL;
    }

    public void setImageFiles(Set<FileDetail> imageFiles) {
        this.imageFiles = imageFiles;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setUnlimited(boolean unlimited) {
        this.unlimited = unlimited;
    }

    public void setAllowFraction(boolean allowFraction) {
        this.allowFraction = allowFraction;
    }

    public void setTotalSupply(double totalSupply) {
        this.totalSupply = totalSupply;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public void setReceiverMarchand(Profile receiverMarchand) {
        this.receiverMarchand = receiverMarchand;
    }

    public void setMarchands(List<Profile> marchands) {
        this.marchands = marchands;
    }

    public void setAccessPermissions(List<Profile> accessPermissions) {
        this.accessPermissions = accessPermissions;
    }

    public void setOrderPeriodicity(String orderPeriodicity) {
        this.orderPeriodicity = orderPeriodicity;
    }

    public void setOrderPeriodicityLabel(String orderPeriodicityLabel) {
        this.orderPeriodicityLabel = orderPeriodicityLabel;
    }

    public void setCreator(Profile creator) {
        this.creator = creator;
    }

    public void setLastModifier(Profile lastModifier) {
        this.lastModifier = lastModifier;
    }

    public void setMaxOrdersPerUser(double maxOrdersPerUser) {
        this.maxOrdersPerUser = maxOrdersPerUser;
    }

    public void setCreatedDate(long createdDate) {
        this.createdDate = createdDate;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setNotProcessedOrders(long notProcessedOrders) {
        this.notProcessedOrders = notProcessedOrders;
    }

    public void setPurchased(double purchased) {
        this.purchased = purchased;
    }

    public void setUserData(UserProductData userData) {
        this.userData = userData;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String toString() {
        return "Product(id=" + this.getId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", illustrationURL=" + this.getIllustrationURL() + ", imageFiles=" + String.valueOf(this.getImageFiles()) + ", enabled=" + this.isEnabled() + ", unlimited=" + this.isUnlimited() + ", allowFraction=" + this.isAllowFraction() + ", totalSupply=" + this.getTotalSupply() + ", price=" + this.getPrice() + ", receiverMarchand=" + String.valueOf(this.getReceiverMarchand()) + ", marchands=" + String.valueOf(this.getMarchands()) + ", accessPermissions=" + String.valueOf(this.getAccessPermissions()) + ", orderPeriodicity=" + this.getOrderPeriodicity() + ", orderPeriodicityLabel=" + this.getOrderPeriodicityLabel() + ", creator=" + String.valueOf(this.getCreator()) + ", lastModifier=" + String.valueOf(this.getLastModifier()) + ", maxOrdersPerUser=" + this.getMaxOrdersPerUser() + ", createdDate=" + this.getCreatedDate() + ", lastModifiedDate=" + this.getLastModifiedDate() + ", notProcessedOrders=" + this.getNotProcessedOrders() + ", purchased=" + this.getPurchased() + ", userData=" + String.valueOf(this.getUserData()) + ", deleted=" + this.isDeleted() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Product)) {
            return false;
        }
        Product other = (Product)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getId() == other.getId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Product;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }
}

