/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.lifecycle;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.picocontainer.Startable;

public class LifeCycleCompletionService
implements Startable {
    private final String THREAD_NUMBER_KEY = "thread-number";
    private final String ASYNC_EXECUTION_KEY = "async-execution";
    private Executor executor;
    private ExecutorCompletionService ecs;
    private final int DEFAULT_THREAD_NUMBER = 1;
    private final boolean DEFAULT_ASYNC_EXECUTION = true;
    private int configThreadNumber;
    private boolean configAsyncExecution;

    public LifeCycleCompletionService(InitParams params) {
        ValueParam threadNumber = params.getValueParam("thread-number");
        ValueParam asyncExecution = params.getValueParam("async-execution");
        try {
            this.configThreadNumber = Integer.valueOf(threadNumber.getValue());
        }
        catch (Exception e) {
            this.configThreadNumber = 1;
        }
        try {
            this.configAsyncExecution = Boolean.valueOf(asyncExecution.getValue());
        }
        catch (Exception e) {
            this.configAsyncExecution = true;
        }
        this.executor = Executors.newFixedThreadPool(this.configThreadNumber);
        this.ecs = new ExecutorCompletionService(this.executor);
    }

    public void addTask(Callable callable) {
        this.ecs.submit(callable);
    }

    public void waitCompletionFinished() {
        try {
            if (this.executor instanceof ExecutorService) {
                ((ExecutorService)this.executor).awaitTermination(1L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isAsync() {
        return this.configAsyncExecution;
    }

    public long getActiveTaskCount() {
        Executor executor = this.executor;
        if (executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
            return threadPoolExecutor.getActiveCount();
        }
        return 0L;
    }

    public void waitAllTaskFinished(long timeout) {
        long start = System.currentTimeMillis();
        try {
            while (this.getActiveTaskCount() != 0L && System.currentTimeMillis() - start <= timeout) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void start() {
    }

    public void stop() {
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdown();
        }
    }
}

