/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.common.ListAccessValidator;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.api.RelationshipStorage;

public class ConnectionListAccess
implements ListAccess<Identity> {
    private RelationshipStorage relationshipStorage;
    Identity identity;
    Type type;

    public ConnectionListAccess(RelationshipStorage relationshipStorage, Identity identity) {
        this.relationshipStorage = relationshipStorage;
        this.identity = identity;
    }

    public ConnectionListAccess(RelationshipStorage relationshipStorage, Identity identity, Type type) {
        this(relationshipStorage, identity);
        this.type = type;
    }

    public Identity[] load(int offset, int limit) throws Exception, IllegalArgumentException {
        ListAccessValidator.validateIndex((int)offset, (int)limit, (int)this.getSize());
        List identities = null;
        switch (this.type.ordinal()) {
            case 0: {
                identities = this.relationshipStorage.getRelationships(this.identity, (long)offset, (long)limit);
                break;
            }
            case 1: {
                identities = this.relationshipStorage.getConnections(this.identity, (long)offset, (long)limit);
                break;
            }
            case 2: {
                identities = this.relationshipStorage.getIncomingRelationships(this.identity, (long)offset, (long)limit);
                break;
            }
            case 3: {
                identities = this.relationshipStorage.getOutgoingRelationships(this.identity, (long)offset, (long)limit);
            }
        }
        return identities.toArray(new Identity[identities.size()]);
    }

    public int getSize() throws Exception {
        switch (this.type.ordinal()) {
            case 0: {
                return this.relationshipStorage.getRelationshipsCount(this.identity);
            }
            case 1: {
                return this.relationshipStorage.getConnectionsCount(this.identity);
            }
            case 2: {
                return this.relationshipStorage.getIncomingRelationshipsCount(this.identity);
            }
            case 3: {
                return this.relationshipStorage.getOutgoingRelationshipsCount(this.identity);
            }
        }
        return 0;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public static enum Type {
        ALL,
        CONNECTION,
        INCOMING,
        OUTGOING,
        PROFILE_FILTER_INCOMMING,
        PROFILE_FILTER_OUTGOING,
        PROFILE_FILTER_CONNECTION;

    }
}

