/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.entity;

import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.social.core.jpa.storage.entity.AppEntity;
import org.exoplatform.social.core.jpa.storage.entity.GroupSpaceBindingEntity;
import org.exoplatform.social.core.jpa.storage.entity.GroupSpaceBindingReportActionEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceMemberEntity;

@Entity(name="SocSpaceEntity")
@Table(name="SOC_SPACES")
@NamedQueries(value={@NamedQuery(name="SpaceEntity.getLastSpaces", query="SELECT sp.id, sp.createdDate FROM SocSpaceEntity sp ORDER BY sp.createdDate DESC"), @NamedQuery(name="SpaceEntity.getSpaceByGroupId", query="SELECT sp FROM SocSpaceEntity sp WHERE sp.groupId = :groupId"), @NamedQuery(name="SpaceEntity.getSpaceByPrettyName", query="SELECT sp FROM SocSpaceEntity sp WHERE sp.prettyName = :prettyName"), @NamedQuery(name="SpaceEntity.getSpaceByDisplayName", query="SELECT sp FROM SocSpaceEntity sp WHERE sp.displayName = :displayName"), @NamedQuery(name="SpaceEntity.getSpaceByURL", query="SELECT sp FROM SocSpaceEntity sp WHERE sp.url = :url"), @NamedQuery(name="SpaceEntity.getCommonSpacesBetweenTwoUsers", query="SELECT spaces FROM SocSpaceEntity spaces WHERE spaces.id IN ( SELECT distinct (t1.space.id) FROM SocSpaceMember t1, SocSpaceMember t2  WHERE t1.userId = :userId  AND t2.userId = :otherUserId  AND t1.space.id = t2.space.id )"), @NamedQuery(name="SpaceEntity.countCommonSpacesBetweenTwoUsers", query="SELECT COUNT(*) FROM SocSpaceEntity spaces WHERE spaces.id IN ( SELECT distinct (t1.space.id) FROM SocSpaceMember t1, SocSpaceMember t2  WHERE t1.userId = :userId  AND t2.userId = :otherUserId  AND t1.space.id = t2.space.id )")})
public class SpaceEntity
implements Serializable {
    private static final long serialVersionUID = 3223615477747436986L;
    @Id
    @SequenceGenerator(name="SEQ_SOC_SPACES_ID", sequenceName="SEQ_SOC_SPACES_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SOC_SPACES_ID")
    @Column(name="SPACE_ID")
    private Long id;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="space", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<SpaceMemberEntity> members = new HashSet<SpaceMemberEntity>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="space", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<GroupSpaceBindingEntity> spaceBindingEntities = new HashSet<GroupSpaceBindingEntity>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="space", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<GroupSpaceBindingReportActionEntity> spaceBindingReportEntities = new HashSet<GroupSpaceBindingReportActionEntity>();
    @ElementCollection
    @CollectionTable(name="SOC_APPS", joinColumns={@JoinColumn(name="SPACE_ID")})
    private Set<AppEntity> app = new HashSet<AppEntity>();
    @Column(name="PRETTY_NAME")
    private String prettyName;
    @Column(name="DISPLAY_NAME")
    private String displayName;
    @Column(name="REGISTRATION")
    private REGISTRATION registration;
    @Column(name="DESCRIPTION")
    private String description;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="AVATAR_LAST_UPDATED")
    private Date avatarLastUpdated;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="BANNER_LAST_UPDATED")
    private Date bannerLastUpdated;
    @Column(name="VISIBILITY")
    public VISIBILITY visibility;
    @Column(name="PRIORITY")
    public PRIORITY priority;
    @Column(name="GROUP_ID")
    public String groupId;
    @Column(name="URL")
    public String url;
    @Column(name="TEMPLATE")
    private String template;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED_DATE", nullable=false)
    private Date createdDate = new Date();
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="UPDATED_DATE", nullable=false)
    private Date updatedDate = new Date();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Set<AppEntity> getApp() {
        return this.app;
    }

    public void setApp(Set<AppEntity> app) {
        this.app = app;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public void setPrettyName(String prettyName) {
        this.prettyName = prettyName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public REGISTRATION getRegistration() {
        return this.registration;
    }

    public void setRegistration(REGISTRATION registration) {
        this.registration = registration;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getAvatarLastUpdated() {
        return this.avatarLastUpdated;
    }

    public void setAvatarLastUpdated(Date avatarLastUpdated) {
        this.avatarLastUpdated = avatarLastUpdated;
    }

    public Date getBannerLastUpdated() {
        return this.bannerLastUpdated;
    }

    public void setBannerLastUpdated(Date bannerLastUpdated) {
        this.bannerLastUpdated = bannerLastUpdated;
    }

    public VISIBILITY getVisibility() {
        return this.visibility;
    }

    public void setVisibility(VISIBILITY visibility) {
        this.visibility = visibility;
    }

    public PRIORITY getPriority() {
        return this.priority;
    }

    public void setPriority(PRIORITY priority) {
        this.priority = priority;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public Set<SpaceMemberEntity> getMembers() {
        return this.members;
    }

    public void setMembers(Set<SpaceMemberEntity> members) {
        this.members = members;
    }

    public Set<GroupSpaceBindingEntity> getSpaceBindingEntities() {
        return this.spaceBindingEntities;
    }

    public void setSpaceBindingEntities(Set<GroupSpaceBindingEntity> spaceBindingEntities) {
        this.spaceBindingEntities = spaceBindingEntities;
    }

    public Set<GroupSpaceBindingReportActionEntity> getSpaceBindingReportEntities() {
        return this.spaceBindingReportEntities;
    }

    public void setSpaceBindingReportEntities(Set<GroupSpaceBindingReportActionEntity> spaceBindingReportEntities) {
        this.spaceBindingReportEntities = spaceBindingReportEntities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpaceEntity that = (SpaceEntity)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.intValue();
    }

    public static enum REGISTRATION {
        OPEN,
        VALIDATION,
        CLOSED;

    }

    public static enum VISIBILITY {
        PUBLIC,
        PRIVATE,
        HIDDEN;

    }

    public static enum PRIORITY {
        HIGH,
        INTERMEDIATE,
        LOW;

    }
}

