/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.ObjectAttachmentDetail;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class AttachmentActivityProcessor
extends BaseActivityProcessorPlugin {
    private AttachmentService attachmentService;

    public AttachmentActivityProcessor(AttachmentService attachmentService, InitParams params) {
        super(params);
        this.attachmentService = attachmentService;
    }

    public void processActivity(ExoSocialActivity activity) {
        if (activity != null && MapUtils.isNotEmpty((Map)activity.getMetadatas()) && CollectionUtils.isNotEmpty((Collection)((Collection)activity.getMetadatas().get(AttachmentService.METADATA_TYPE.getName())))) {
            List attachmentMetadataItems = (List)activity.getMetadatas().get(AttachmentService.METADATA_TYPE.getName());
            attachmentMetadataItems.forEach(metadataItem -> {
                String fileId = metadataItem.getMetadata().getName();
                String objectId = activity.getMetadataObjectId();
                String objectType = activity.getMetadataObjectType();
                ObjectAttachmentDetail attachment = this.attachmentService.getAttachment(objectType, objectId, fileId);
                if (attachment == null) {
                    return;
                }
                Map metadataItemProperties = metadataItem.getProperties();
                HashMap<String, String> properties = metadataItem.getMetadata().getProperties();
                if (properties == null) {
                    properties = new HashMap<String, String>();
                    metadataItem.setProperties(properties);
                }
                if (metadataItemProperties != null) {
                    properties.put("alt", (String)metadataItemProperties.get("alt"));
                }
                properties.put("fileName", attachment.getName());
                properties.put("fileSize", String.valueOf(attachment.getSize()));
                properties.put("fileMimeType", attachment.getMimetype());
                properties.put("fileUpdateDate", String.valueOf(attachment.getUpdated()));
            });
        }
    }
}

