/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache;

import java.io.Serializable;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.social.core.storage.cache.loader.CacheLoader;
import org.exoplatform.social.core.storage.cache.loader.ServiceContext;
import org.exoplatform.social.core.storage.cache.model.key.CacheKey;

public enum CacheType {
    IDENTITY("social.IdentityCache"),
    IDENTITY_INDEX("social.IdentityIndexCache"),
    PROFILE("social.ProfileCache"),
    IDENTITIES_COUNT("social.IdentitiesCountCache"),
    IDENTITIES("social.IdentitiesCache"),
    PROFILE_AVATAR("social.ProfileAvatar"),
    RELATIONSHIP("social.RelationshipCache"),
    RELATIONSHIP_FROM_IDENTITY("social.RelationshipFromIdentityCache"),
    RELATIONSHIPS_COUNT("social.RelationshipsCountCache"),
    RELATIONSHIPS("social.RelationshipsCache"),
    SUGGESTIONS("social.SuggestionsCache"),
    ACTIVITY("social.ActivityCache"),
    ACTIVITIES_COUNT("social.ActivitiesCountCache"),
    ACTIVITIES("social.ActivitiesCache"),
    ACTIVITY_REF("social.ActivityRefCache"),
    ACTIVITIES_REF_COUNT("social.ActivitiesRefCountCache"),
    ACTIVITIES_REF("social.ActivitiesRefCache"),
    SPACE("social.SpaceCache"),
    SPACE_REF("social.SpaceRefCache"),
    SPACES_COUNT("social.SpacesCountCache"),
    SPACES("social.SpacesCache"),
    SPACE_SIMPLE("social.SpaceSimpleCache");

    private final String name;

    private CacheType(String name) {
        this.name = name;
    }

    public <K extends CacheKey, V extends Serializable> ExoCache<K, V> getFromService(CacheService service) {
        return service.getCacheInstance(this.name);
    }

    public <K extends CacheKey, V extends Serializable> FutureExoCache<K, V, ServiceContext<V>> createFutureCache(ExoCache<K, V> cache) {
        return new FutureExoCache(new CacheLoader(), cache);
    }
}

