/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.chain.web.MutableParameterMap;

public abstract class AbstractSessionScopeMap<S, R>
implements Map<String, Object> {
    private S session = null;
    private R request;
    private MutableParameterMap<S, Object> parameterMap = null;

    public AbstractSessionScopeMap(R request) {
        this.request = request;
        this.sessionExists();
    }

    @Override
    public void clear() {
        if (this.sessionExists()) {
            this.parameterMap.clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.sessionExists() && this.parameterMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return value != null && this.sessionExists() && this.parameterMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.sessionExists() ? this.parameterMap.entrySet() : new HashSet();
    }

    @Override
    public Object get(Object key) {
        return this.sessionExists() ? this.parameterMap.get(key) : null;
    }

    @Override
    public boolean isEmpty() {
        return !this.sessionExists() || this.parameterMap.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.sessionExists() ? this.parameterMap.keySet() : new HashSet();
    }

    @Override
    public Object put(String key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        return this.sessionExists(true) ? this.parameterMap.put(key, value) : null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        map.forEach(this::put);
    }

    @Override
    public Object remove(Object key) {
        return this.sessionExists() ? this.parameterMap.remove(key) : null;
    }

    @Override
    public int size() {
        return this.sessionExists() ? this.parameterMap.size() : 0;
    }

    @Override
    public Collection<Object> values() {
        return this.sessionExists() ? this.parameterMap.values() : new ArrayList();
    }

    @Override
    public int hashCode() {
        return this.sessionExists() ? this.parameterMap.hashCode() : 0;
    }

    @Override
    public boolean equals(Object obj) {
        return this.sessionExists() && this.parameterMap.equals(obj);
    }

    public String toString() {
        if (this.request != null) {
            return "{request: " + this.request + '}';
        }
        if (this.session != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("{session: ").append(this.session);
            if (this.parameterMap != null) {
                sb.append(", parameters: ").append(this.parameterMap);
            }
            return sb.append('}').toString();
        }
        return "{}";
    }

    protected S getSession() {
        return this.session;
    }

    protected R getRequest() {
        return this.request;
    }

    protected boolean sessionExists() {
        return this.sessionExists(false);
    }

    protected boolean sessionExists(boolean create) {
        if (this.session == null && this.request != null) {
            this.session = this.getSession(create);
            if (this.session != null) {
                this.request = null;
                this.parameterMap = this.createParameterMap();
            }
        }
        if (this.session == null) {
            this.parameterMap = null;
            return false;
        }
        return this.parameterMap != null;
    }

    protected abstract S getSession(boolean var1);

    protected abstract MutableParameterMap<S, Object> createParameterMap();
}

