/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.organization.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.commons.utils.SerializablePageList;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.organization.account.UIGroupSelector;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/organization/account/UIUserGroupSelector.gtmpl", events={@EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={FindGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
@Serialized
public class UIUserGroupSelector
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_KEYWORD = "Quick Search";
    public static final String FIELD_FILTER = "filter";
    public static final String FIELD_GROUP = "group";
    public static String USER_NAME = "userName";
    public static String LAST_NAME = "lastName";
    public static String FIRST_NAME = "firstName";
    public static String EMAIL = "email";
    protected Map<String, User> userData_ = new HashMap<String, User>();
    private boolean isShowSearch_ = false;
    private boolean isShowSearchGroup = true;
    private boolean isShowSearchUser = true;
    protected String groupId_ = null;
    protected Collection<String> pars_;
    public UIPageIterator uiIterator_;
    private String selectedUsers;
    private boolean multi = true;
    private UserStatus statusFilter = UserStatus.ENABLED;
    private LazyPageList lazyPageList;

    public UIUserGroupSelector() throws Exception {
        this.addUIFormInput(new UIFormStringInput(FIELD_KEYWORD, FIELD_KEYWORD, null));
        this.addUIFormInput(new UIFormSelectBox(FIELD_FILTER, FIELD_FILTER, this.getFilters()));
        this.addUIFormInput(new UIFormStringInput(FIELD_GROUP, FIELD_GROUP, null));
        this.isShowSearch_ = true;
        OrganizationService service = this.getApplicationComponent(OrganizationService.class);
        ListAccess userList = service.getUserHandler().findAllUsers();
        this.lazyPageList = new LazyPageList(userList, 10);
        this.uiIterator_ = new UIPageIterator();
        this.uiIterator_.setPageList((PageList)this.lazyPageList);
        this.uiIterator_.setId("UISelectUserPage");
        UIPopupWindow uiPopup = this.addChild(UIPopupWindow.class, null, "UIPopupGroupSelector");
        uiPopup.setWindowSize(540, 0);
        UIGroupSelector uiGroup = this.createUIComponent(UIGroupSelector.class, null, null);
        uiPopup.setUIComponent(uiGroup);
        uiGroup.setId("GroupSelector");
        uiGroup.getChild(UITree.class).setId("TreeGroupSelector");
        uiGroup.getChild(UIBreadcumbs.class).setId("BreadcumbsGroupSelector");
    }

    public List<User> getData() throws Exception {
        if (this.getMulti()) {
            for (Object obj : this.uiIterator_.getCurrentPageData()) {
                User user = (User)obj;
                UIFormCheckBoxInput<Boolean> uiFormCheckBoxInput = this.getUIFormCheckBoxInput(user.getUserName());
                if (uiFormCheckBoxInput == null) {
                    uiFormCheckBoxInput = new UIFormCheckBoxInput<Boolean>(user.getUserName(), user.getUserName(), false);
                    this.addUIFormInput(uiFormCheckBoxInput);
                }
                uiFormCheckBoxInput.setChecked(this.uiIterator_.isSelectedItem(user.getUserName()));
            }
        }
        return new ArrayList<User>(this.uiIterator_.getCurrentPageData());
    }

    public String getSelectedUsers() {
        return this.selectedUsers;
    }

    public void setSelectedUsers(String selectedUsers) {
        this.selectedUsers = selectedUsers;
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    public boolean getMulti() {
        return this.multi;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiIterator_;
    }

    public long getAvailablePage() {
        return this.uiIterator_.getAvailablePage();
    }

    public long getCurrentPage() {
        return this.uiIterator_.getCurrentPage();
    }

    private List<SelectItemOption<String>> getFilters() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption<String>(USER_NAME, USER_NAME));
        options.add(new SelectItemOption<String>(LAST_NAME, LAST_NAME));
        options.add(new SelectItemOption<String>(FIRST_NAME, FIRST_NAME));
        options.add(new SelectItemOption<String>(EMAIL, EMAIL));
        return options;
    }

    @Override
    public String[] getActions() {
        return new String[]{"Add", "Close"};
    }

    @Override
    public void activate() {
    }

    @Override
    public void deActivate() {
    }

    @Override
    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    public void setShowSearch(boolean isShowSearch) {
        this.isShowSearch_ = isShowSearch;
    }

    public boolean isShowSearch() {
        return this.isShowSearch_;
    }

    public void setShowSearchGroup(boolean isShowSearchGroup) {
        this.isShowSearchGroup = isShowSearchGroup;
    }

    public boolean isShowSearchGroup() {
        return this.isShowSearchGroup;
    }

    public void setShowSearchUser(boolean isShowSearchUser) {
        this.isShowSearchUser = isShowSearchUser;
    }

    public void search(String keyword, String filter, String groupId) throws Exception {
        OrganizationService service = this.getApplicationComponent(OrganizationService.class);
        Query q = new Query();
        if (keyword != null && ((String)(keyword = ((String)keyword).trim())).length() != 0) {
            if (((String)keyword).indexOf("*") < 0) {
                if (((String)keyword).charAt(0) != '*') {
                    keyword = "*" + (String)keyword;
                }
                if (((String)keyword).charAt(((String)keyword).length() - 1) != '*') {
                    keyword = (String)keyword + "*";
                }
            }
            keyword = ((String)keyword).replace('?', '_');
            if (USER_NAME.equals(filter)) {
                q.setUserName((String)keyword);
            }
            if (LAST_NAME.equals(filter)) {
                q.setLastName((String)keyword);
            }
            if (FIRST_NAME.equals(filter)) {
                q.setFirstName((String)keyword);
            }
            if (EMAIL.equals(filter)) {
                q.setEmail((String)keyword);
            }
        }
        if (groupId != null && (groupId = groupId.trim()).length() != 0) {
            CopyOnWriteArrayList results = new CopyOnWriteArrayList();
            results.addAll(service.getUserHandler().findUsers(q).getAll());
            MembershipHandler memberShipHandler = service.getMembershipHandler();
            for (Object user : results) {
                if (memberShipHandler.findMembershipsByUserAndGroup(((User)user).getUserName(), groupId).size() != 0) continue;
                results.remove(user);
            }
            SerializablePageList objPageList = new SerializablePageList((ListAccess)new ListAccessImpl(User.class, results), 10);
            this.uiIterator_.setPageList((PageList)objPageList);
        } else {
            this.uiIterator_.setPageList((PageList)new SerializablePageList(service.getUserHandler().findUsersByQuery(q, this.statusFilter), 10));
        }
    }

    public boolean isShowSearchUser() {
        return this.isShowSearchUser;
    }

    public UserStatus getStatusFilter() {
        return this.statusFilter;
    }

    public void setStatusFilter(UserStatus statusFilter) {
        this.statusFilter = statusFilter;
    }

    public String getSelectedGroup() {
        return (String)this.getUIStringInput(FIELD_GROUP).getValue();
    }

    public void setSelectedGroup(String selectedGroup) {
        this.getUIStringInput(FIELD_GROUP).setValue(selectedGroup);
    }

    public PageList removeDuplicate(PageList users) throws Exception {
        ArrayList after = new ArrayList();
        for (Object u : users.getAll()) {
            if (after.contains(u)) continue;
            after.add(u);
        }
        return new ObjectPageList(after, 10);
    }

    protected void updateCurrentPage(int page) throws Exception {
        this.uiIterator_.setCurrentPage(page);
    }

    public void setKeyword(String value) {
        this.getUIStringInput(FIELD_KEYWORD).setValue(value);
    }

    private void setSelectedItem() throws Exception {
        for (Object o : this.uiIterator_.getCurrentPageData()) {
            User u = (User)o;
            UIFormCheckBoxInput input = this.getUIFormCheckBoxInput(u.getUserName());
            if (input == null) continue;
            this.uiIterator_.setSelectedItem(u.getUserName(), input.isChecked());
        }
    }

    public static class ShowPageActionListener
    extends EventListener<UIUserGroupSelector> {
        @Override
        public void execute(Event<UIUserGroupSelector> event) throws Exception {
            UIUserGroupSelector uiSelectUserForm = event.getSource();
            uiSelectUserForm.setSelectedItem();
            int page = Integer.parseInt(event.getRequestContext().getRequestParameter("objectId"));
            uiSelectUserForm.updateCurrentPage(page);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSelectUserForm);
        }
    }

    public static class SearchGroupActionListener
    extends EventListener<UIUserGroupSelector> {
        @Override
        public void execute(Event<UIUserGroupSelector> event) throws Exception {
            UIUserGroupSelector uiForm = event.getSource();
            uiForm.getChild(UIPopupWindow.class).setShow(true);
        }
    }

    public static class CloseActionListener
    extends EventListener<UIUserGroupSelector> {
        @Override
        public void execute(Event<UIUserGroupSelector> event) throws Exception {
            UIUserGroupSelector uiForm = event.getSource();
            uiForm.getParent().broadcast(event, event.getExecutionPhase());
        }
    }

    public static class SearchActionListener
    extends EventListener<UIUserGroupSelector> {
        @Override
        public void execute(Event<UIUserGroupSelector> event) throws Exception {
            UIUserGroupSelector uiForm = event.getSource();
            String keyword = (String)uiForm.getUIStringInput(UIUserGroupSelector.FIELD_KEYWORD).getValue();
            String filter = (String)uiForm.getUIFormSelectBox(UIUserGroupSelector.FIELD_FILTER).getValue();
            String groupId = uiForm.getSelectedGroup();
            uiForm.search(keyword, filter, groupId);
            if (filter == null || filter.trim().length() == 0) {
                return;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm);
        }
    }

    public static class FindGroupActionListener
    extends EventListener<UIUserGroupSelector> {
        @Override
        public void execute(Event<UIUserGroupSelector> event) throws Exception {
            UIUserGroupSelector uiSelectUserForm = event.getSource();
            String groupId = uiSelectUserForm.getSelectedGroup();
            OrganizationService service = uiSelectUserForm.getApplicationComponent(OrganizationService.class);
            PageList users = PageList.EMPTY_LIST;
            if (groupId != null && groupId.trim().length() != 0) {
                if (service.getGroupHandler().findGroupById(groupId) != null) {
                    users = uiSelectUserForm.removeDuplicate(service.getUserHandler().findUsersByGroup(groupId));
                }
            } else {
                users = service.getUserHandler().findUsers(new Query());
            }
            users.setPageSize(10);
            uiSelectUserForm.uiIterator_.setPageList(users);
            uiSelectUserForm.setKeyword(null);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSelectUserForm);
        }
    }

    public static class SelectGroupActionListener
    extends EventListener<UIGroupSelector> {
        @Override
        public void execute(Event<UIGroupSelector> event) throws Exception {
            UIGroupSelector uiSelectGroupForm = event.getSource();
            UIUserGroupSelector uiSelectUserForm = (UIUserGroupSelector)((UIComponent)uiSelectGroupForm.getParent()).getParent();
            String groupId = event.getRequestContext().getRequestParameter("objectId");
            uiSelectUserForm.setSelectedGroup(groupId);
            OrganizationService service = uiSelectGroupForm.getApplicationComponent(OrganizationService.class);
            PageList users = uiSelectUserForm.removeDuplicate(service.getUserHandler().findUsersByGroup(groupId));
            users.setPageSize(10);
            uiSelectUserForm.uiIterator_.setPageList(users);
            uiSelectUserForm.setKeyword(null);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSelectUserForm);
        }
    }

    public static class AddUserActionListener
    extends EventListener<UIUserGroupSelector> {
        @Override
        public void execute(Event<UIUserGroupSelector> event) throws Exception {
            UIUserGroupSelector uiForm = event.getSource();
            String userName = event.getRequestContext().getRequestParameter("objectId");
            uiForm.setSelectedUsers(userName);
            uiForm.getParent().broadcast(event, event.getExecutionPhase());
        }
    }

    public static class AddActionListener
    extends EventListener<UIUserGroupSelector> {
        @Override
        public void execute(Event<UIUserGroupSelector> event) throws Exception {
            UIUserGroupSelector uiForm = event.getSource();
            StringBuilder sb = new StringBuilder();
            uiForm.setSelectedItem();
            Set<String> items = uiForm.uiIterator_.getSelectedItems();
            if (items.size() == 0) {
                UIApplication uiApp = uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIUserSelector.msg.user-required", null));
                return;
            }
            Object[] arrItems = items.toArray(new String[items.size()]);
            Arrays.sort(arrItems);
            for (Object key : arrItems) {
                if (sb.toString() != null && sb.toString().trim().length() != 0) {
                    sb.append(",");
                }
                sb.append((String)key);
            }
            uiForm.setSelectedUsers(sb.toString());
            uiForm.getParent().broadcast(event, event.getExecutionPhase());
        }
    }
}

