/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.xml.transform.NotSupportedIOTypeException;
import org.exoplatform.services.xml.transform.impl.trax.TRAXTemplatesServiceImpl;
import org.exoplatform.services.xml.transform.trax.TRAXTemplates;
import org.exoplatform.services.xml.transform.trax.TRAXTemplatesService;
import org.exoplatform.services.xml.transform.trax.TRAXTransformer;

public class XSLTStreamingOutput
implements StreamingOutput {
    private String schemeName;
    private Source source;
    private Map<String, String> xsltParams;

    public XSLTStreamingOutput(String schemeName, Source source) {
        this.schemeName = schemeName;
        this.source = source;
    }

    public XSLTStreamingOutput(String schemeName, Source source, Map<String, String> xsltParams) {
        this(schemeName, source);
        this.xsltParams = xsltParams;
    }

    public void write(OutputStream outStream) throws IOException, WebApplicationException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        TRAXTemplatesService templatesService = (TRAXTemplatesService)container.getComponentInstanceOfType(TRAXTemplatesServiceImpl.class);
        try {
            TRAXTemplates t;
            TRAXTransformer transformer = null;
            if (this.schemeName != null) {
                t = templatesService.getTemplates(this.schemeName);
                if (t == null) {
                    String msg = "Template " + this.schemeName + " not found.";
                    throw new IllegalArgumentException(msg);
                }
            } else {
                throw new IllegalArgumentException("XSLT scheme name is null.");
            }
            transformer = t.newTransformer();
            transformer.initResult((Result)new StreamResult(outStream));
            if (this.xsltParams != null) {
                for (Map.Entry<String, String> e : this.xsltParams.entrySet()) {
                    transformer.setParameter(e.getKey(), (Object)e.getValue());
                }
            }
            transformer.transform(this.source);
        }
        catch (TransformerConfigurationException tce) {
            throw new IOException("Can't write to output stream " + String.valueOf(tce), tce);
        }
        catch (NotSupportedIOTypeException nse) {
            throw new IOException("Can't write to output stream " + String.valueOf((Object)nse), nse);
        }
        catch (TransformerException tre) {
            throw new IOException("Can't write to output stream " + String.valueOf(tre), tre);
        }
    }
}

