/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.data;

import io.meeds.oauth.spi.OAuthCodec;
import io.meeds.oauth.spi.OAuthProviderProcessor;
import io.meeds.oauth.spi.OAuthProviderType;
import io.meeds.oauth.spi.OAuthProviderTypeRegistry;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileHandler;

public class AccessTokenInvalidationListener
extends UserProfileEventListener {
    private static Log log = ExoLogger.getLogger(AccessTokenInvalidationListener.class);
    private final UserProfileHandler userProfileHandler;
    private final OAuthProviderTypeRegistry oauthProviderTypeRegistry;
    private final OAuthCodec oauthCodec;

    public AccessTokenInvalidationListener(OrganizationService orgService, OAuthProviderTypeRegistry oauthProviderTypeRegistry, OAuthCodec oauthCodec) {
        this.userProfileHandler = orgService.getUserProfileHandler();
        this.oauthProviderTypeRegistry = oauthProviderTypeRegistry;
        this.oauthCodec = oauthCodec;
    }

    public void preSave(UserProfile userProfile, boolean isNew) throws Exception {
        UserProfile foundUserProfile = this.userProfileHandler.findUserProfileByName(userProfile.getUserName());
        if (foundUserProfile == null) {
            foundUserProfile = this.userProfileHandler.createUserProfileInstance(userProfile.getUserName());
        }
        for (OAuthProviderType opt : this.oauthProviderTypeRegistry.getEnabledOAuthProviders()) {
            String foundOauthProviderUsername;
            String oauthProviderUsername = userProfile.getAttribute(opt.getUserNameAttrName());
            if (Safe.equals((Object)oauthProviderUsername, (Object)(foundOauthProviderUsername = foundUserProfile.getAttribute(opt.getUserNameAttrName())))) continue;
            OAuthProviderProcessor processor = opt.getOauthProviderProcessor();
            Object currentAccessToken = processor.getAccessTokenFromUserProfile(userProfile, this.oauthCodec);
            Object foundAccessToken = processor.getAccessTokenFromUserProfile(foundUserProfile, this.oauthCodec);
            if (currentAccessToken == null || !currentAccessToken.equals(foundAccessToken)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Removing accessToken for oauthProvider=" + String.valueOf(opt) + ", username=" + userProfile.getUserName()));
            }
            processor.removeAccessTokenFromUserProfile(userProfile);
        }
    }
}

