/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.dao;

import io.meeds.gamification.entity.BadgeEntity;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.TypedQuery;
import java.util.Collections;
import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class BadgeDAO
extends GenericDAOJPAImpl<BadgeEntity, Long> {
    private static final String DOMAIN_ID = "domainId";

    public BadgeEntity findBadgeByTitle(String badgeTitle) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationBadge.findBadgeByTitle", BadgeEntity.class).setParameter("badgeTitle", (Object)badgeTitle);
        try {
            return (BadgeEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public BadgeEntity findBadgeByTitleAndProgramId(String badgeTitle, long programId) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationBadge.findBadgeByTitleAndDomain", BadgeEntity.class).setParameter("badgeTitle", (Object)badgeTitle).setParameter(DOMAIN_ID, (Object)programId);
        try {
            return (BadgeEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<BadgeEntity> findBadgesByProgramId(long domainId) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationBadge.findBadgeByDomain", BadgeEntity.class).setParameter(DOMAIN_ID, (Object)domainId);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<BadgeEntity> findEnabledBadgesByProgramId(long domainId) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationBadge.findEnabledBadgeByDomain", BadgeEntity.class).setParameter(DOMAIN_ID, (Object)domainId);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<BadgeEntity> getAllBadges() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationBadge.getAllBadges", BadgeEntity.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }
}

