/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.rest;

import io.meeds.appcenter.model.ApplicationImage;
import io.meeds.appcenter.model.GeneralSettings;
import io.meeds.appcenter.service.ApplicationCenterService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"settings"})
@Tag(name="/app-center/rest/settings", description="Manage and access application center applications")
public class ApplicationSettingsRest {
    @Autowired
    private ApplicationCenterService appCenterService;

    @GetMapping
    @Secured(value={"users"})
    @Operation(summary="Modifies default application image setting", method="GET", description="Modifies default application image setting and returns an empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public GeneralSettings getSettings() {
        return this.appCenterService.getSettings();
    }

    @PatchMapping(path={"maxFavorites"})
    @Secured(value={"administrators"})
    @Operation(summary="Modifies maximum application count to add as favorites for all users", method="PATCH", description="Modifies maximum application count to add as favorites for all users")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void setMaxFavoriteApps(@Parameter(description="Max favorites number", required=true) @RequestParam(value="number") long number) {
        this.appCenterService.setMaxFavoriteApps(number);
    }

    @PatchMapping(path={"image"})
    @Secured(value={"administrators"})
    @Operation(summary="Modifies default application image setting", method="PATCH", description="Modifies default application image setting")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void setDefaultAppImage(@Parameter(description="Application image id, body and name", required=true) @RequestBody ApplicationImage defaultAppImage) {
        this.appCenterService.setDefaultAppImage(defaultAppImage);
    }
}

