/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.bayeux.server;

import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;

public interface Authorizer {
    default public void authorize(Operation operation, ChannelId channel, ServerSession session, ServerMessage message, Promise<Result> promise) {
        promise.succeed((Object)this.authorize(operation, channel, session, message));
    }

    public Result authorize(Operation var1, ChannelId var2, ServerSession var3, ServerMessage var4);

    public static enum Operation {
        CREATE,
        SUBSCRIBE,
        PUBLISH;

    }

    public static abstract class Result {
        public static Result deny(String reason) {
            return new Denied(reason);
        }

        public static Result grant() {
            return Granted.GRANTED;
        }

        public static Result ignore() {
            return Ignored.IGNORED;
        }

        public boolean isDenied() {
            return false;
        }

        public boolean isGranted() {
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName().toLowerCase();
        }

        public static final class Denied
        extends Result {
            private final String reason;

            private Denied(String reason) {
                if (reason == null) {
                    reason = "";
                }
                this.reason = reason;
            }

            public String getReason() {
                return this.reason;
            }

            @Override
            public boolean isDenied() {
                return true;
            }

            @Override
            public String toString() {
                return super.toString() + " (reason='" + this.reason + "')";
            }
        }

        public static final class Granted
        extends Result {
            private static final Granted GRANTED = new Granted();

            private Granted() {
            }

            @Override
            public boolean isGranted() {
                return true;
            }
        }

        public static final class Ignored
        extends Result {
            private static final Ignored IGNORED = new Ignored();

            private Ignored() {
            }
        }
    }
}

