/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.service;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.model.ContractDetail;
import org.exoplatform.wallet.service.WalletContractService;
import org.exoplatform.wallet.service.WalletService;
import org.exoplatform.wallet.utils.WalletUtils;
import org.json.JSONArray;
import org.picocontainer.Startable;

public class WalletContractServiceImpl
implements WalletContractService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(WalletContractServiceImpl.class);
    private static final String ADDRESS_PARAMETER_IS_MANDATORY_MESSAGE = "address parameter is mandatory";
    private static final String SYMBOL_PROPERTY_NAME = "exo.wallet.blockchain.token.symbol";
    private static final String CRYPTOCURRENCY_PROPERTY_NAME = "exo.wallet.blockchain.network.cryptocurrency";
    private ConfigurationManager configurationManager;
    private String contractAbiPath;
    private JSONArray contractAbi;
    private String contractBinaryPath;
    private String contractBinary;
    private SettingService settingService;
    private WalletService walletService;

    public WalletContractServiceImpl(SettingService settingService, ConfigurationManager configurationManager, InitParams params) {
        this.configurationManager = configurationManager;
        this.settingService = settingService;
        if (params.containsKey((Object)"contract.abi.path")) {
            this.contractAbiPath = params.getValueParam("contract.abi.path").getValue();
        }
        if (StringUtils.isBlank((CharSequence)this.contractAbiPath)) {
            LOG.warn((Object)"Contract ABI path is empty, thus no contract deployment is possible");
        }
        if (params.containsKey((Object)"contract.bin.path")) {
            this.contractBinaryPath = params.getValueParam("contract.bin.path").getValue();
        }
        if (StringUtils.isBlank((CharSequence)this.contractBinaryPath)) {
            LOG.warn((Object)"Contract BIN path is empty, thus no contract deployment is possible");
        }
    }

    public void start() {
        try {
            String contractAbiString = IOUtil.getStreamContentAsString((InputStream)this.configurationManager.getInputStream(this.contractAbiPath));
            this.contractAbi = new JSONArray(contractAbiString);
            this.contractBinary = IOUtil.getStreamContentAsString((InputStream)this.configurationManager.getInputStream(this.contractBinaryPath));
            if (!this.contractBinary.startsWith("0x")) {
                this.contractBinary = "0x" + this.contractBinary;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Can't read ABI/BIN files content", (Throwable)e);
        }
    }

    public void stop() {
    }

    public boolean isContract(String address) {
        return this.getContractDetail(address) != null;
    }

    public void saveContractDetail(ContractDetail contractDetail) {
        if (contractDetail == null) {
            throw new IllegalArgumentException("contractDetail is mandatory");
        }
        String contractAddress = contractDetail.getAddress();
        if (StringUtils.isBlank((CharSequence)contractAddress)) {
            throw new IllegalArgumentException(ADDRESS_PARAMETER_IS_MANDATORY_MESSAGE);
        }
        String contractDetailString = WalletUtils.toJsonString((Object)contractDetail);
        this.setCustomTokenSymbol(contractDetail);
        this.setNetworkCryptoCurrency(contractDetail);
        this.settingService.set(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, StringUtils.lowerCase((String)contractAddress), SettingValue.create((String)contractDetailString));
        this.getWalletService().setConfiguredContractDetail(contractDetail);
    }

    public ContractDetail getContractDetail(String address) {
        if (StringUtils.isBlank((CharSequence)address)) {
            return null;
        }
        SettingValue contractDetailValue = this.settingService.get(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, StringUtils.lowerCase((String)address));
        if (contractDetailValue != null && contractDetailValue.getValue() != null) {
            String value = contractDetailValue.getValue().toString();
            try {
                ContractDetail contractDetail = (ContractDetail)WalletUtils.fromJsonString((String)value, ContractDetail.class);
                this.setCustomTokenSymbol(contractDetail);
                this.setNetworkCryptoCurrency(contractDetail);
                return contractDetail;
            }
            catch (Exception e) {
                LOG.debug("Remove old data stored in settings service for wallet with address '{}', having as value '{}'", new Object[]{address, value, e});
                this.settingService.remove(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, StringUtils.lowerCase((String)address));
                return null;
            }
        }
        return null;
    }

    public JSONArray getContractAbi() {
        return this.contractAbi;
    }

    public String getContractBinary() {
        return this.contractBinary;
    }

    public String getContractFileContent(String name, String extension) throws IOException {
        try (InputStream abiInputStream = this.getClass().getClassLoader().getResourceAsStream("org/exoplatform/wallet/contract/" + name + "." + extension);){
            String string = IOUtils.toString((InputStream)abiInputStream, (Charset)Charset.defaultCharset());
            return string;
        }
    }

    private WalletService getWalletService() {
        if (this.walletService == null) {
            this.walletService = (WalletService)CommonsUtils.getService(WalletService.class);
        }
        return this.walletService;
    }

    private void setNetworkCryptoCurrency(ContractDetail contractDetail) {
        String cryptocurrency = PropertyManager.getProperty((String)CRYPTOCURRENCY_PROPERTY_NAME);
        if (StringUtils.isNotBlank((CharSequence)cryptocurrency)) {
            contractDetail.setCryptocurrency(cryptocurrency);
        } else {
            contractDetail.setCryptocurrency("E");
        }
    }

    private void setCustomTokenSymbol(ContractDetail contractDetail) {
        String symbol = PropertyManager.getProperty((String)SYMBOL_PROPERTY_NAME);
        if (StringUtils.isNotBlank((CharSequence)symbol)) {
            contractDetail.setSymbol(symbol);
        } else if (StringUtils.isNotBlank((CharSequence)contractDetail.getSymbol())) {
            contractDetail.setSymbol(contractDetail.getSymbol().substring(0, 1));
        }
    }
}

