/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.profilelabel;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.social.core.model.ProfileLabel;
import org.exoplatform.social.core.profilelabel.ProfileLabelService;
import org.exoplatform.social.core.profilelabel.storage.ProfileLabelStorage;

public class ProfileLabelServiceImpl
implements ProfileLabelService {
    private final ProfileLabelStorage profileLabelStorage;

    public ProfileLabelServiceImpl(ProfileLabelStorage profileLabelStorage) {
        this.profileLabelStorage = profileLabelStorage;
    }

    public ProfileLabel findLabelByObjectTypeAndObjectIdAndLang(String objectType, String objectId, String language) {
        return this.profileLabelStorage.findLabelByObjectTypeAndObjectIdAndLang(objectType, objectId, language);
    }

    public List<ProfileLabel> findLabelByObjectTypeAndObjectId(String objectType, String objectId) {
        return this.profileLabelStorage.findLabelByObjectTypeAndObjectId(objectType, objectId);
    }

    public void createLabel(ProfileLabel profileLabel) throws ObjectAlreadyExistsException {
        if (profileLabel == null) {
            throw new IllegalArgumentException("ProfileLabel Item Object is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)profileLabel.getObjectType())) {
            throw new IllegalArgumentException("Object type is mandatory");
        }
        if (profileLabel.getObjectId() == null) {
            throw new IllegalArgumentException("Object Id is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)profileLabel.getLanguage())) {
            throw new IllegalArgumentException("language is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)profileLabel.getLabel())) {
            throw new IllegalArgumentException("profileLabel value is mandatory");
        }
        ProfileLabel storedProfileLabel = this.profileLabelStorage.findLabelByObjectTypeAndObjectIdAndLang(profileLabel.getObjectType(), profileLabel.getObjectId(), profileLabel.getLanguage());
        if (storedProfileLabel != null) {
            throw new ObjectAlreadyExistsException((Object)storedProfileLabel, "ProfileLabel already exist");
        }
        profileLabel.setId(null);
        this.profileLabelStorage.saveLabel(profileLabel, true);
    }

    public void updateLabel(ProfileLabel profileLabel) {
        if (StringUtils.isBlank((CharSequence)profileLabel.getObjectType())) {
            throw new IllegalArgumentException("Object type is mandatory");
        }
        if (profileLabel.getObjectId() == null) {
            throw new IllegalArgumentException("Object Id is mandatory");
        }
        this.profileLabelStorage.saveLabel(profileLabel, false);
    }

    public void deleteLabel(long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException("ProfileLabel Technical Identifier is mandatory");
        }
        this.profileLabelStorage.deleteLabel(id);
    }
}

