/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.cursor.internal;

import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.engine.jdbc.cursor.internal.FallbackRefCursorSupport;
import org.hibernate.engine.jdbc.cursor.internal.StandardRefCursorSupport;
import org.hibernate.engine.jdbc.cursor.spi.RefCursorSupport;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class RefCursorSupportInitiator
implements StandardServiceInitiator<RefCursorSupport> {
    public static final RefCursorSupportInitiator INSTANCE = new RefCursorSupportInitiator();

    @Override
    public RefCursorSupport initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        JdbcServices jdbcServices = registry.getService(JdbcServices.class);
        assert (jdbcServices != null);
        boolean supportsRefCursors = this.useRefCursorSupport(jdbcServices);
        if (supportsRefCursors) {
            return new StandardRefCursorSupport(jdbcServices);
        }
        return new FallbackRefCursorSupport(jdbcServices);
    }

    private boolean useRefCursorSupport(JdbcServices jdbcServices) {
        Boolean dialectAnswer = jdbcServices.getDialect().supportsRefCursors();
        if (dialectAnswer != null) {
            return dialectAnswer;
        }
        return jdbcServices.getJdbcEnvironment().getExtractedDatabaseMetaData().supportsRefCursors();
    }

    @Override
    public Class<RefCursorSupport> getServiceInitiated() {
        return RefCursorSupport.class;
    }
}

