/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;

public class LocalTemporaryTableStrategy {
    public static final String SHORT_NAME = "local_temporary";
    public static final String DROP_ID_TABLES = "hibernate.query.mutation_strategy.local_temporary.drop_tables";
    private final TemporaryTable temporaryTable;
    private final SessionFactoryImplementor sessionFactory;
    private boolean dropIdTables;

    public LocalTemporaryTableStrategy(TemporaryTable temporaryTable, SessionFactoryImplementor sessionFactory) {
        this.temporaryTable = temporaryTable;
        this.sessionFactory = sessionFactory;
    }

    public void prepare(MappingModelCreationProcess mappingModelCreationProcess, JdbcConnectionAccess connectionAccess) {
        ConfigurationService configService = mappingModelCreationProcess.getCreationContext().getBootstrapContext().getServiceRegistry().getService(ConfigurationService.class);
        this.dropIdTables = configService.getSetting(DROP_ID_TABLES, StandardConverters.BOOLEAN, Boolean.valueOf(false));
    }

    public void release(SessionFactoryImplementor sessionFactory, JdbcConnectionAccess connectionAccess) {
    }

    public TemporaryTable getTemporaryTable() {
        return this.temporaryTable;
    }

    public EntityMappingType getEntityDescriptor() {
        return this.getTemporaryTable().getEntityDescriptor();
    }

    public boolean isDropIdTables() {
        return this.dropIdTables;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }
}

