/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.impl;

import java.util.HashMap;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class SpaceNotificationImpl
extends SpaceListenerPlugin {
    private WebNotificationService webNotificationService;
    private static final Log LOG = ExoLogger.getExoLogger(SpaceNotificationImpl.class);

    public void removeInvitedUser(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String userId = event.getTarget();
        this.removeNotifications(space.getId(), userId, "SpaceInvitationPlugin");
        String[] managers = space.getManagers();
        if (managers != null && managers.length > 0) {
            for (String manager : managers) {
                this.removeNotifications(space.getId(), manager, "RequestJoinSpacePlugin");
            }
        }
    }

    public void removePendingUser(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String userId = event.getTarget();
        this.removeNotifications(space.getId(), userId, "SpaceInvitationPlugin");
        String[] managers = space.getManagers();
        if (managers != null && managers.length > 0) {
            for (String manager : managers) {
                this.removeNotifications(space.getId(), manager, "RequestJoinSpacePlugin");
            }
        }
    }

    public void joined(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String userId = event.getTarget();
        this.updateNotificationsStatus(space, userId, "SpaceInvitationPlugin");
        String[] managers = space.getManagers();
        if (managers != null && managers.length > 0) {
            for (String manager : managers) {
                this.updateNotificationsStatus(space, manager, "RequestJoinSpacePlugin");
            }
        }
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String userId = event.getTarget();
        String senderRemoteId = space.getEditor();
        Identity identity = Utils.getIdentityManager().getOrCreateUserIdentity(senderRemoteId);
        String senderName = identity.getProfile().getFullName();
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(SocialNotificationUtils.REMOTE_ID, (Object)userId).append(SocialNotificationUtils.SPACE, (Object)space).append(SocialNotificationUtils.PROFILE, (Object)identity.getProfile()).append(SocialNotificationUtils.SENDER, (Object)senderName);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"SpaceInvitationPlugin"))).execute(ctx);
    }

    public void addPendingUser(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String userId = event.getTarget();
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(SocialNotificationUtils.REMOTE_ID, (Object)userId).append(SocialNotificationUtils.SPACE, (Object)space);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"RequestJoinSpacePlugin"))).execute(ctx);
    }

    private void removeNotifications(String spaceId, String userId, String pluginId) {
        WebNotificationFilter webNotificationFilter = new WebNotificationFilter(userId);
        webNotificationFilter.setParameter("spaceId", spaceId);
        webNotificationFilter.setPluginKey(new PluginKey(pluginId));
        List webNotifs = this.getWebNotificationService().getNotificationInfos(webNotificationFilter, 0, -1);
        for (NotificationInfo notificationInfo : webNotifs) {
            this.getWebNotificationService().remove(notificationInfo.getId());
        }
    }

    private void updateNotificationsStatus(Space space, String userId, String pluginId) {
        WebNotificationFilter webNotificationFilter = new WebNotificationFilter(userId);
        webNotificationFilter.setParameter("spaceId", space.getId());
        webNotificationFilter.setPluginKey(new PluginKey(pluginId));
        List webNotifs = this.getWebNotificationService().getNotificationInfos(webNotificationFilter, 0, -1);
        for (NotificationInfo info : webNotifs) {
            if (info.getTo().equals(userId) && info.isRead() && "accepted".equals(info.getOwnerParameter().get("status"))) continue;
            info.setTo(userId);
            info.setRead(true);
            info.setOwnerParameter(new HashMap(info.getOwnerParameter()));
            info.getOwnerParameter().put("status", "accepted");
            this.updateNotification(info);
        }
    }

    private void updateNotification(NotificationInfo notification) {
        NotificationContext nCtx = NotificationContextImpl.cloneInstance().setNotificationInfo(notification);
        BaseNotificationPlugin plugin = nCtx.getPluginContainer().getPlugin(notification.getKey());
        if (plugin != null) {
            try {
                notification.setRead(false);
                notification.setOnPopOver(true);
                this.getWebNotificationService().save(notification);
            }
            catch (Exception e) {
                LOG.error("Can not update space invitation notification.", new Object[]{e.getMessage()});
            }
        }
    }

    private WebNotificationService getWebNotificationService() {
        if (this.webNotificationService == null) {
            this.webNotificationService = (WebNotificationService)CommonsUtils.getService(WebNotificationService.class);
        }
        return this.webNotificationService;
    }
}

