/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.impl;

import java.util.Iterator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.security.StateKey;

public class MembershipUpdateListener
extends MembershipEventListener {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.organization.api.MembershipUpdateListener");
    private ConversationRegistry conversationRegistry;

    public MembershipUpdateListener(ConversationRegistry conversationRegistry) {
        this.conversationRegistry = conversationRegistry;
    }

    @Override
    public void postDelete(Membership m) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)">>> In postDelete");
        }
        String userId = m.getUserName();
        MembershipEntry expected = new MembershipEntry(m.getGroupId(), m.getMembershipType());
        for (StateKey key : this.conversationRegistry.getStateKeys(userId)) {
            ConversationState cstate = this.conversationRegistry.getState(key);
            Identity identity = cstate.getIdentity();
            Iterator iter = identity.getMemberships().iterator();
            while (iter.hasNext()) {
                MembershipEntry tmp = (MembershipEntry)iter.next();
                if (!tmp.equals((Object)expected)) continue;
                iter.remove();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Removed membership entry " + String.valueOf(tmp)));
            }
        }
    }

    @Override
    public void postSave(Membership m, boolean isNew) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)">>> In postSave");
        }
        String userId = m.getUserName();
        MembershipEntry me = new MembershipEntry(m.getGroupId(), m.getMembershipType());
        for (StateKey key : this.conversationRegistry.getStateKeys(userId)) {
            ConversationState cstate = this.conversationRegistry.getState(key);
            Identity identity = cstate.getIdentity();
            Iterator iter = identity.getMemberships().iterator();
            boolean contains = false;
            while (iter.hasNext()) {
                if (!((MembershipEntry)iter.next()).equals((Object)me)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            identity.getMemberships().add(me);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Added membership entry " + String.valueOf(me)));
        }
    }

    @Override
    public void preDelete(Membership m) throws Exception {
    }

    @Override
    public void preSave(Membership m, boolean isNew) throws Exception {
    }
}

