/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.service;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.portal.security.constant.UserRegistrationType;
import io.meeds.portal.security.service.SecuritySettingService;
import io.meeds.tenant.hub.service.HubService;
import io.meeds.tenant.metamask.service.MetamaskLoginService$AjcClosure1;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpSession;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.account.setup.web.AccountSetupService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.picketlink.idm.api.SecureRandomProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

@Service
public class MetamaskLoginService {
    public static final String LOGIN_MESSAGE_ATTRIBUTE_NAME = "metamask_login_message";
    private static final Log LOG;
    @Autowired
    private SecuritySettingService securitySettingService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private UserACL userAcl;
    @Autowired
    private SecureRandomProvider secureRandomProvider;
    @Autowired
    private AccountSetupService accountSetupService;
    @Autowired
    private HubService hubService;
    @Value(value="#{'${meeds.login.metamask.allowedRootAccessWallets:}'.split(',')}")
    private List<String> allowedRootWallets = new ArrayList<String>();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    @ContainerTransactional
    public void init() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        MetamaskLoginService$AjcClosure1 metamaskLoginService$AjcClosure1 = new MetamaskLoginService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(metamaskLoginService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public boolean isAllowUserRegistration() {
        return this.securitySettingService.getRegistrationType() == UserRegistrationType.OPEN;
    }

    public boolean isAllowUserRegistration(String walletAddress) {
        if (this.isAllowUserRegistration()) {
            return true;
        }
        return this.isDeedManager(walletAddress);
    }

    public boolean isDeedManager(String walletAddress) {
        return this.hubService.isDeedManager(walletAddress);
    }

    public boolean isSuperUser(String walletAddress) {
        return CollectionUtils.isNotEmpty(this.allowedRootWallets) && this.allowedRootWallets.stream().anyMatch(address -> StringUtils.equalsIgnoreCase((CharSequence)address, (CharSequence)walletAddress));
    }

    public String getUserWithWalletAddress(String walletAddress) {
        if (this.isSuperUser(walletAddress)) {
            return this.userAcl.getSuperUser();
        }
        try {
            User user = this.organizationService.getUserHandler().findUserByName(walletAddress.toLowerCase());
            if (user != null) {
                return user.getUserName();
            }
        }
        catch (Exception e) {
            LOG.warn("Error retrieving username from walletAddress {}", new Object[]{walletAddress, e});
        }
        return null;
    }

    public boolean validateSignedMessage(String walletAddress, String rawMessage, String signedMessage) {
        if (StringUtils.isBlank((CharSequence)walletAddress) || StringUtils.isBlank((CharSequence)rawMessage) || StringUtils.isBlank((CharSequence)signedMessage)) {
            return false;
        }
        try {
            BigInteger publicKey;
            String recoveredAddress;
            byte[] signatureBytes = Numeric.hexStringToByteArray((String)signedMessage);
            if (signatureBytes.length < 64) {
                return false;
            }
            byte[] r = Arrays.copyOfRange(signatureBytes, 0, 32);
            byte[] s = Arrays.copyOfRange(signatureBytes, 32, 64);
            byte v = signatureBytes[64];
            if (v < 27) {
                v = (byte)(v + 27);
            }
            if ((recoveredAddress = "0x" + Keys.getAddress((BigInteger)(publicKey = Sign.signedPrefixedMessageToKey((byte[])rawMessage.getBytes(), (Sign.SignatureData)new Sign.SignatureData(v, r, s))))).equalsIgnoreCase(walletAddress)) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.warn("Error verifying signedPrefixed Message for wallet {}. Consider user as not authenticated.", new Object[]{walletAddress, e});
            return false;
        }
        return false;
    }

    public String generateLoginMessage(HttpSession session, boolean renew) {
        String token = this.getLoginMessage(session);
        if (token != null && !renew) {
            return token;
        }
        token = this.generateRandomToken();
        if (session != null) {
            session.setAttribute(LOGIN_MESSAGE_ATTRIBUTE_NAME, (Object)token);
        }
        return token;
    }

    public String generateLoginMessage(HttpSession session) {
        return this.generateLoginMessage(session, false);
    }

    public String getLoginMessage(HttpSession session) {
        return session == null ? null : (String)session.getAttribute(LOGIN_MESSAGE_ATTRIBUTE_NAME);
    }

    public boolean isDeedHub() {
        try {
            return this.hubService.isConnected();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error checking whether the current installation is a Deed Tenant or not, return false", (Throwable)e);
            return false;
        }
    }

    public long getDeedId() {
        return this.hubService.getDeedId();
    }

    private String generateRandomToken() {
        SecureRandom secureRandom = this.secureRandomProvider.getSecureRandom();
        return secureRandom.nextLong() + "-" + secureRandom.nextLong() + "-" + secureRandom.nextLong();
    }

    private void secureRootPassword() {
        UserHandler userHandler = this.organizationService.getUserHandler();
        if (userHandler == null) {
            return;
        }
        try {
            User rootUser = userHandler.findUserByName(this.userAcl.getSuperUser());
            if (rootUser == null) {
                LOG.warn((Object)"Root user wasn't found, can't regenerate password.");
            } else {
                LOG.info((Object)"Regenerate root password to allow accessing it via Metamask only");
                rootUser.setPassword(this.generateRandomToken());
                userHandler.saveUser(rootUser, false);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Can't secure root access", (Throwable)e);
        }
    }

    public void setAllowedRootWallets(List<String> allowedRootWallets) {
        this.allowedRootWallets = allowedRootWallets;
    }

    static {
        MetamaskLoginService.ajc$preClinit();
        LOG = ExoLogger.getLogger(MetamaskLoginService.class);
    }

    static /* synthetic */ void init_aroundBody0(MetamaskLoginService ajc$this, JoinPoint joinPoint) {
        ajc$this.allowedRootWallets = ajc$this.allowedRootWallets.stream().filter(StringUtils::isNotBlank).toList();
        if (CollectionUtils.isNotEmpty(ajc$this.allowedRootWallets)) {
            ajc$this.accountSetupService.setSkipSetup(true);
            ajc$this.secureRootPassword();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MetamaskLoginService.java", MetamaskLoginService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "io.meeds.tenant.metamask.service.MetamaskLoginService", "", "", "", "void"), 85);
    }
}

