/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.scheduling.task;

import io.meeds.twitter.gamification.model.Tweet;
import io.meeds.twitter.gamification.model.TwitterAccount;
import io.meeds.twitter.gamification.model.TwitterTrigger;
import io.meeds.twitter.gamification.scheduling.task.TwitterRemoteUpdateTask$AjcClosure1;
import io.meeds.twitter.gamification.service.TwitterConsumerService;
import io.meeds.twitter.gamification.service.TwitterService;
import io.meeds.twitter.gamification.service.TwitterTriggerService;
import io.meeds.twitter.gamification.utils.Utils;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class TwitterRemoteUpdateTask {
    private static final Log LOG;
    @Autowired
    private TwitterConsumerService twitterConsumerService;
    @Autowired
    private TwitterService twitterAccountService;
    @Autowired
    private TwitterTriggerService twitterTriggerService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @ExoTransactional
    @Scheduled(cron="${io.meeds.gamification.TwitterAccountRemoteUpdate.expression:0 */15 * * * ?}")
    public void execute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        TwitterRemoteUpdateTask$AjcClosure1 twitterRemoteUpdateTask$AjcClosure1 = new TwitterRemoteUpdateTask$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(twitterRemoteUpdateTask$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private void processTwitterAccount(TwitterAccount twitterAccount, String bearerToken) {
        try {
            List<TwitterTrigger> mentionTriggers = this.twitterConsumerService.getMentionEvents(twitterAccount, twitterAccount.getLastMentionTweetId(), bearerToken);
            if (CollectionUtils.isNotEmpty(mentionTriggers)) {
                this.processMentionTriggers(mentionTriggers, twitterAccount);
            }
        }
        catch (ObjectNotFoundException e) {
            LOG.warn("Error while updating twitter account {}", new Object[]{twitterAccount.getId(), e});
        }
    }

    private void processMentionTriggers(List<TwitterTrigger> mentionTriggers, TwitterAccount twitterAccount) throws ObjectNotFoundException {
        for (TwitterTrigger trigger : mentionTriggers) {
            this.twitterTriggerService.handleTriggerAsync(trigger);
        }
        this.twitterAccountService.updateAccountLastMentionTweetId(twitterAccount.getId(), mentionTriggers.get(0).getTweetId());
    }

    private void processTweetReactionsUpdate(Tweet tweet, String bearerToken) {
        Set<String> tweetLikers = this.twitterConsumerService.retrieveTweetLikers(tweet.getTweetLink(), bearerToken);
        Set<String> tweetRetweeters = this.twitterConsumerService.retrieveTweetRetweeters(tweet.getTweetLink(), bearerToken);
        if (!CollectionUtils.isEqualCollection(tweetLikers, tweet.getLikers())) {
            tweetLikers.stream().filter(liker -> !tweet.getLikers().contains(liker)).forEach(liker -> {
                TwitterTrigger twitterTrigger = new TwitterTrigger();
                twitterTrigger.setType("tweet");
                twitterTrigger.setTrigger("likeTweet");
                twitterTrigger.setTwitterUsername((String)liker);
                String tweetId = Utils.extractTweetId(tweet.getTweetLink());
                if (StringUtils.isNotBlank((CharSequence)tweetId)) {
                    twitterTrigger.setTweetId(Long.parseLong(tweetId));
                }
                this.twitterTriggerService.handleTriggerAsync(twitterTrigger);
            });
        }
        if (!CollectionUtils.isEqualCollection(tweetRetweeters, tweet.getRetweeters())) {
            tweetRetweeters.stream().filter(retweeter -> !tweet.getRetweeters().contains(retweeter)).forEach(retweeter -> {
                TwitterTrigger twitterTrigger = new TwitterTrigger();
                twitterTrigger.setType("tweet");
                twitterTrigger.setTrigger("retweet");
                twitterTrigger.setTwitterUsername((String)retweeter);
                String tweetId = Utils.extractTweetId(tweet.getTweetLink());
                if (StringUtils.isNotBlank((CharSequence)tweetId)) {
                    twitterTrigger.setTweetId(Long.parseLong(tweetId));
                }
                this.twitterTriggerService.handleTriggerAsync(twitterTrigger);
            });
        }
        if (!CollectionUtils.isEqualCollection(tweetLikers, tweet.getLikers()) || !CollectionUtils.isEqualCollection(tweetRetweeters, tweet.getRetweeters())) {
            try {
                this.twitterAccountService.updateTweetReactions(tweet.getTweetId(), tweetLikers, tweetRetweeters);
            }
            catch (ObjectNotFoundException e) {
                LOG.warn("Error while updating tweet reactions {}", new Object[]{tweet.getTweetId(), e});
            }
        }
    }

    static {
        TwitterRemoteUpdateTask.ajc$preClinit();
        LOG = ExoLogger.getLogger(TwitterRemoteUpdateTask.class);
    }

    static /* synthetic */ void execute_aroundBody0(TwitterRemoteUpdateTask ajc$this, JoinPoint joinPoint) {
        List<Tweet> tweets;
        String bearerToken = ajc$this.twitterAccountService.getTwitterBearerToken();
        if (StringUtils.isBlank((CharSequence)bearerToken)) {
            return;
        }
        List<TwitterAccount> twitterAccounts = ajc$this.twitterAccountService.getTwitterAccounts();
        if (!twitterAccounts.isEmpty()) {
            twitterAccounts.forEach(twitterAccount -> this.processTwitterAccount((TwitterAccount)twitterAccount, bearerToken));
        }
        if (!(tweets = ajc$this.twitterAccountService.getTweets()).isEmpty()) {
            tweets.forEach(tweet -> this.processTweetReactionsUpdate((Tweet)tweet, bearerToken));
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TwitterRemoteUpdateTask.java", TwitterRemoteUpdateTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "io.meeds.twitter.gamification.scheduling.task.TwitterRemoteUpdateTask", "", "", "", "void"), 61);
    }
}

