/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core.lifecycle;

import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

public class UIApplicationLifecycle
extends Lifecycle<UIPortletApplication> {
    @Override
    public void processDecode(UIPortletApplication uicomponent, WebuiRequestContext context) throws Exception {
        String componentId = context.getRequestParameter(context.getUIComponentIdParameterName());
        if (componentId == null || componentId.length() == 0) {
            return;
        }
        Object uiTarget = uicomponent.findComponentById(componentId);
        if (uiTarget == null) {
            return;
        }
        if (uiTarget == uicomponent) {
            super.processDecode(uicomponent, context);
        } else {
            ((UIComponent)uiTarget).processDecode(context);
        }
    }

    @Override
    public void processAction(UIPortletApplication uicomponent, WebuiRequestContext context) throws Exception {
        String componentId = context.getRequestParameter(context.getUIComponentIdParameterName());
        if (componentId != null) {
            Object uiTarget = uicomponent.findComponentById(componentId);
            if (uiTarget == uicomponent) {
                super.processAction(uicomponent, context);
            } else if (uiTarget != null) {
                ((UIComponent)uiTarget).processAction(context);
            } else {
                log.warn("Could not find UIComponent with ID {}", new Object[]{componentId});
            }
        }
    }

    @Override
    public void processRender(UIPortletApplication uicomponent, WebuiRequestContext context) throws Exception {
        if (uicomponent.getTemplate() != null) {
            super.processRender(uicomponent, context);
            return;
        }
        UIPortletApplication uiApp = uicomponent;
        context.getWriter().append("<div id=\"").append(uicomponent.getId()).append("\"").append(" class=\"").append(uicomponent.getId()).append("\">");
        uiApp.renderChildren();
        context.getWriter().append("</div>");
    }
}

