/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Embeddable
public class AppEntity
implements Serializable {
    private static final long serialVersionUID = -8893364434133832686L;
    private static final Log LOG = ExoLogger.getLogger(AppEntity.class);
    @Column(name="APP_ID", nullable=false)
    private String appId;
    @Column(name="APP_NAME", nullable=false)
    private String appName;
    @Column(name="REMOVABLE", nullable=false)
    private boolean isRemovable;
    @Column(name="STATUS", nullable=false)
    private Status status;

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public boolean isRemovable() {
        return this.isRemovable;
    }

    public void setRemovable(boolean isRemovable) {
        this.isRemovable = isRemovable;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public static Set<AppEntity> parse(String apps) {
        if (apps == null) {
            return Collections.emptySet();
        }
        HashSet<AppEntity> entities = new HashSet<AppEntity>();
        for (String app : apps.split(",")) {
            String[] appPart = app.split(":");
            if (appPart.length == 4) {
                AppEntity entity = new AppEntity();
                entity.setAppId(appPart[0]);
                entity.setAppName(appPart[1]);
                entity.setRemovable(Boolean.parseBoolean(appPart[2]));
                entity.setStatus(Status.valueOf(appPart[3].toUpperCase()));
                entities.add(entity);
                continue;
            }
            LOG.warn("Bad format for space application {}", new Object[]{app});
        }
        return entities;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getAppId());
        builder.append(":").append(this.getAppName());
        builder.append(":").append(this.isRemovable());
        builder.append(":").append(this.getStatus().name().toLowerCase());
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appId == null ? 0 : this.appId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppEntity other = (AppEntity)obj;
        return !(this.appId == null ? other.appId != null : !this.appId.equals(other.appId));
    }

    public static enum Status {
        ACTIVE,
        DEACTIVE,
        INSTALLED;

    }
}

