/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web.jakarta.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.web.jakarta.ChainServlet;
import org.apache.commons.chain.web.jakarta.servlet.ServletWebContext;

public class ChainProcessor
extends ChainServlet {
    private static final long serialVersionUID = -6817532768031279260L;
    public static final String CATALOG = "org.apache.commons.chain.CATALOG";
    public static final String CATALOG_DEFAULT = "org.apache.commons.chain.CATALOG";
    public static final String COMMAND = "org.apache.commons.chain.COMMAND";
    private static final String COMMAND_DEFAULT = "command";
    private String attribute = null;
    private String catalog = null;
    private String command = null;

    public void destroy() {
        super.destroy();
        this.attribute = null;
        this.catalog = null;
        this.command = null;
    }

    public void init() throws ServletException {
        super.init();
        this.attribute = this.getServletConfig().getInitParameter("org.apache.commons.chain.CONFIG_ATTR");
        this.catalog = this.getServletConfig().getInitParameter("org.apache.commons.chain.CATALOG");
        this.command = this.getServletConfig().getInitParameter(COMMAND);
        if (this.command == null) {
            this.command = COMMAND_DEFAULT;
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Catalog catalog;
        ServletWebContext context = new ServletWebContext(this.getServletContext(), request, response);
        Catalog theCatalog = null;
        theCatalog = this.attribute != null ? (catalog = (Catalog)this.getServletContext().getAttribute(this.attribute)) : (this.catalog != null ? CatalogFactory.getInstance().getCatalog(this.catalog) : CatalogFactory.getInstance().getCatalog());
        if (this.attribute == null) {
            request.setAttribute("org.apache.commons.chain.CATALOG", (Object)theCatalog);
        }
        Command command = theCatalog.getCommand(this.command);
        try {
            command.execute((Context)context);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

