/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.boot.internal;

import jakarta.persistence.PersistenceException;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.spi.ClassTransformer;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.jpa.internal.enhance.EnhancingClassTransformerImpl;

public class PersistenceUnitInfoDescriptor
implements PersistenceUnitDescriptor {
    private final PersistenceUnitInfo persistenceUnitInfo;
    private ClassTransformer classTransformer;

    public PersistenceUnitInfoDescriptor(PersistenceUnitInfo persistenceUnitInfo) {
        this.persistenceUnitInfo = persistenceUnitInfo;
    }

    @Override
    public URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitInfo.getPersistenceUnitRootUrl();
    }

    @Override
    public String getName() {
        return this.persistenceUnitInfo.getPersistenceUnitName();
    }

    @Override
    public Object getNonJtaDataSource() {
        return this.persistenceUnitInfo.getNonJtaDataSource();
    }

    @Override
    public Object getJtaDataSource() {
        return this.persistenceUnitInfo.getJtaDataSource();
    }

    @Override
    public String getProviderClassName() {
        return this.persistenceUnitInfo.getPersistenceProviderClassName();
    }

    @Override
    public PersistenceUnitTransactionType getTransactionType() {
        return this.persistenceUnitInfo.getTransactionType();
    }

    @Override
    public boolean isUseQuotedIdentifiers() {
        return false;
    }

    @Override
    public Properties getProperties() {
        return this.persistenceUnitInfo.getProperties();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.persistenceUnitInfo.getClassLoader();
    }

    @Override
    public ClassLoader getTempClassLoader() {
        return this.persistenceUnitInfo.getNewTempClassLoader();
    }

    @Override
    public boolean isExcludeUnlistedClasses() {
        return this.persistenceUnitInfo.excludeUnlistedClasses();
    }

    @Override
    public ValidationMode getValidationMode() {
        return this.persistenceUnitInfo.getValidationMode();
    }

    @Override
    public SharedCacheMode getSharedCacheMode() {
        return this.persistenceUnitInfo.getSharedCacheMode();
    }

    @Override
    public List<String> getManagedClassNames() {
        return this.persistenceUnitInfo.getManagedClassNames();
    }

    @Override
    public List<String> getMappingFileNames() {
        return this.persistenceUnitInfo.getMappingFileNames();
    }

    @Override
    public List<URL> getJarFileUrls() {
        return this.persistenceUnitInfo.getJarFileUrls();
    }

    @Override
    public void pushClassTransformer(EnhancementContext enhancementContext) {
        if (this.classTransformer != null) {
            throw new PersistenceException("Persistence unit [" + this.persistenceUnitInfo.getPersistenceUnitName() + "] can only have a single class transformer.");
        }
        if (this.persistenceUnitInfo.getNewTempClassLoader() != null) {
            EnhancingClassTransformerImpl classTransformer = new EnhancingClassTransformerImpl(enhancementContext);
            this.classTransformer = classTransformer;
            this.persistenceUnitInfo.addTransformer((jakarta.persistence.spi.ClassTransformer)classTransformer);
        }
    }

    @Override
    public ClassTransformer getClassTransformer() {
        return this.classTransformer;
    }
}

