/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.cluster;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class ClusterNodeName
implements Startable {
    private static final String CLUSTER_NODE_NAME = "exo.cluster.node.name";
    private static final Log LOG = ExoLogger.getLogger(ClusterNodeName.class);
    private String nodeName;
    private IDGeneratorService idGeneratorService;

    public ClusterNodeName(IDGeneratorService idGeneratorService) {
        this.idGeneratorService = idGeneratorService;
    }

    public void start() {
        boolean clusterEnabled;
        this.nodeName = PropertyManager.getProperty((String)CLUSTER_NODE_NAME);
        boolean bl = clusterEnabled = PropertyManager.getProperty((String)"exo.profiles") != null ? PropertyManager.getProperty((String)"exo.profiles").contains("cluster") : false;
        if (clusterEnabled && StringUtils.isBlank((CharSequence)this.nodeName)) {
            this.nodeName = "node-" + this.idGeneratorService.generateStringID((Object)Long.toString(System.currentTimeMillis()));
            PropertyManager.setProperty((String)CLUSTER_NODE_NAME, (String)this.nodeName);
            LOG.warn("Cluster node name is not configured, node name will be auto generated. Cluster node name {}", new Object[]{this.nodeName});
        }
    }

    public void stop() {
    }

    public String getNodeName() {
        return this.nodeName;
    }
}

