/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.resource;

import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/i18n/bundle")
public class ResourceBundleREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ResourceBundleREST.class);
    private static final CacheControl CACHE_CONTROL = new CacheControl();
    private static final Date DEFAULT_LAST_MODIFED = new Date();
    private static final int CACHE_IN_SECONDS = 604800;
    private static final int CACHE_IN_MILLI_SECONDS = 604800000;
    private ResourceBundleService resourceBundleService;
    private LocaleConfigService localeConfigService;

    public ResourceBundleREST(ResourceBundleService resourceBundleService, LocaleConfigService localeConfigService) {
        this.resourceBundleService = resourceBundleService;
        this.localeConfigService = localeConfigService;
    }

    @GET
    @Path(value="{name}-{lang}.json")
    @Produces(value={"application/json"})
    public Response getBundleContent(@Context Request request, @PathParam(value="name") String resourceBundleName, @PathParam(value="lang") String lang, @PathParam(value="v") String version) {
        if (StringUtils.isBlank((CharSequence)resourceBundleName) || StringUtils.isBlank((CharSequence)lang)) {
            return Response.status((int)400).build();
        }
        String eTagValue = version == null ? String.valueOf(System.currentTimeMillis()) : version;
        EntityTag eTag = new EntityTag(eTagValue);
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (PropertyManager.isDevelopping() || builder == null) {
            LocaleConfig localeConfig = this.localeConfigService.getLocaleConfig(lang);
            if (localeConfig == null) {
                LOG.warn("Locale '{}' is not supported", new Object[]{lang});
                return Response.status((int)400).build();
            }
            String content = this.resourceBundleService.getResourceBundleContent(resourceBundleName, localeConfig.getLocale());
            if (content == null) {
                return Response.status((int)404).build();
            }
            builder = Response.ok((Object)content, (String)"application/json");
            builder.cacheControl(CACHE_CONTROL);
            builder.expires(new Date(System.currentTimeMillis() + 604800000L));
            builder.lastModified(DEFAULT_LAST_MODIFED);
        }
        return builder.build();
    }

    static {
        CACHE_CONTROL.setMaxAge(604800);
    }
}

