/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.slm.PutLifecycleResponse;
import co.elastic.clients.elasticsearch.slm.Retention;
import co.elastic.clients.elasticsearch.slm.SlmConfiguration;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutLifecycleRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final SlmConfiguration config;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final String name;
    private final String policyId;
    @Nullable
    private final String repository;
    @Nullable
    private final Retention retention;
    @Nullable
    private final String schedule;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutLifecycleRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutLifecycleRequest::setupPutLifecycleRequestDeserializer);
    public static final Endpoint<PutLifecycleRequest, PutLifecycleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutLifecycleRequest, PutLifecycleResponse>("es/slm.put_lifecycle", request -> "PUT", request -> {
        boolean _policyId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_slm");
            buf.append("/policy");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.policyId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _policyId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("policyId", request.policyId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutLifecycleResponse._DESERIALIZER);

    private PutLifecycleRequest(Builder builder) {
        this.config = builder.config;
        this.masterTimeout = builder.masterTimeout;
        this.name = builder.name;
        this.policyId = ApiTypeHelper.requireNonNull(builder.policyId, this, "policyId");
        this.repository = builder.repository;
        this.retention = builder.retention;
        this.schedule = builder.schedule;
        this.timeout = builder.timeout;
    }

    public static PutLifecycleRequest of(Function<Builder, ObjectBuilder<PutLifecycleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final SlmConfiguration config() {
        return this.config;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    public final String policyId() {
        return this.policyId;
    }

    @Nullable
    public final String repository() {
        return this.repository;
    }

    @Nullable
    public final Retention retention() {
        return this.retention;
    }

    @Nullable
    public final String schedule() {
        return this.schedule;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.config != null) {
            generator.writeKey("config");
            this.config.serialize(generator, mapper);
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.repository != null) {
            generator.writeKey("repository");
            generator.write(this.repository);
        }
        if (this.retention != null) {
            generator.writeKey("retention");
            this.retention.serialize(generator, mapper);
        }
        if (this.schedule != null) {
            generator.writeKey("schedule");
            generator.write(this.schedule);
        }
    }

    protected static void setupPutLifecycleRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::config, SlmConfiguration._DESERIALIZER, "config");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::repository, JsonpDeserializer.stringDeserializer(), "repository");
        op.add(Builder::retention, Retention._DESERIALIZER, "retention");
        op.add(Builder::schedule, JsonpDeserializer.stringDeserializer(), "schedule");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutLifecycleRequest> {
        @Nullable
        private SlmConfiguration config;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private String name;
        private String policyId;
        @Nullable
        private String repository;
        @Nullable
        private Retention retention;
        @Nullable
        private String schedule;
        @Nullable
        private Time timeout;

        public final Builder config(@Nullable SlmConfiguration value) {
            this.config = value;
            return this;
        }

        public final Builder config(Function<SlmConfiguration.Builder, ObjectBuilder<SlmConfiguration>> fn) {
            return this.config(fn.apply(new SlmConfiguration.Builder()).build());
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public final Builder policyId(String value) {
            this.policyId = value;
            return this;
        }

        public final Builder repository(@Nullable String value) {
            this.repository = value;
            return this;
        }

        public final Builder retention(@Nullable Retention value) {
            this.retention = value;
            return this;
        }

        public final Builder retention(Function<Retention.Builder, ObjectBuilder<Retention>> fn) {
            return this.retention(fn.apply(new Retention.Builder()).build());
        }

        public final Builder schedule(@Nullable String value) {
            this.schedule = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutLifecycleRequest build() {
            this._checkSingleUse();
            return new PutLifecycleRequest(this);
        }
    }
}

