/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.BitSet;
import org.hibernate.QueryException;
import org.hibernate.QueryParameterException;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.query.ParameterLabelException;
import org.hibernate.query.sql.spi.ParameterRecognizer;

public class ParameterParser {
    private static final String HQL_SEPARATORS = " \n\r\f\t,()=<>&|+-=/*'^![]#~\\";
    private static final BitSet HQL_SEPARATORS_BITSET = new BitSet();

    private ParameterParser() {
    }

    public static void parse(String sqlString, ParameterRecognizer recognizer, boolean nativeJdbcParametersIgnored) throws QueryException {
        ParameterParser.checkIsNotAFunctionCall(sqlString);
        int stringLength = sqlString.length();
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        boolean inLineComment = false;
        boolean inDelimitedComment = false;
        for (int indx = 0; indx < stringLength; ++indx) {
            String param;
            int chopLocation;
            int right;
            boolean lastCharacter;
            char c = sqlString.charAt(indx);
            boolean bl = lastCharacter = indx == stringLength - 1;
            if (inSingleQuotes) {
                recognizer.other(c);
                if ('\'' != c) continue;
                inSingleQuotes = false;
                continue;
            }
            if (inDoubleQuotes) {
                recognizer.other(c);
                if ('\"' != c) continue;
                inDoubleQuotes = false;
                continue;
            }
            if (inDelimitedComment) {
                recognizer.other(c);
                if (lastCharacter || '*' != c || '/' != sqlString.charAt(indx + 1)) continue;
                inDelimitedComment = false;
                recognizer.other(sqlString.charAt(indx + 1));
                ++indx;
                continue;
            }
            if (inLineComment) {
                recognizer.other(c);
                if ('\n' == c) {
                    inLineComment = false;
                    continue;
                }
                if ('\r' != c) continue;
                inLineComment = false;
                if (lastCharacter || '\n' != sqlString.charAt(indx + 1)) continue;
                recognizer.other(sqlString.charAt(indx + 1));
                ++indx;
                continue;
            }
            if (!lastCharacter && '/' == c && '*' == sqlString.charAt(indx + 1)) {
                inDelimitedComment = true;
                recognizer.other(c);
                recognizer.other(sqlString.charAt(indx + 1));
                ++indx;
                continue;
            }
            if ('-' == c) {
                recognizer.other(c);
                if (lastCharacter || '-' != sqlString.charAt(indx + 1)) continue;
                inLineComment = true;
                recognizer.other(sqlString.charAt(indx + 1));
                ++indx;
                continue;
            }
            if ('\"' == c) {
                inDoubleQuotes = true;
                recognizer.other(c);
                continue;
            }
            if ('\'' == c) {
                inSingleQuotes = true;
                recognizer.other(c);
                continue;
            }
            if ('\\' == c) {
                recognizer.other(sqlString.charAt(++indx));
                continue;
            }
            if (c == ':') {
                if (indx < stringLength - 1 && Character.isJavaIdentifierStart(sqlString.charAt(indx + 1))) {
                    right = StringHelper.firstIndexOfChar(sqlString, HQL_SEPARATORS_BITSET, indx + 1);
                    chopLocation = right < 0 ? sqlString.length() : right;
                    param = sqlString.substring(indx + 1, chopLocation);
                    if (param.isEmpty()) {
                        throw new QueryParameterException("Space is not allowed after parameter prefix ':'", sqlString);
                    }
                    recognizer.namedParameter(param, indx);
                    indx = chopLocation - 1;
                    continue;
                }
                if (indx < stringLength - 3 && sqlString.charAt(indx + 1) == ':' && sqlString.charAt(indx + 2) == ':' && sqlString.charAt(indx + 3) == ':') {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedNativeQueryColonEscaping("::::", "::");
                    recognizer.other(':');
                    recognizer.other(':');
                    indx += 3;
                    continue;
                }
                if (indx < stringLength - 2 && sqlString.charAt(indx + 1) == ':' && sqlString.charAt(indx + 2) == '=') {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedNativeQueryColonEscaping("::=", ":=");
                    recognizer.other(':');
                    recognizer.other('=');
                    indx += 2;
                    continue;
                }
                recognizer.other(':');
                while (indx < stringLength - 1 && sqlString.charAt(indx + 1) == ':') {
                    ++indx;
                    recognizer.other(':');
                }
                continue;
            }
            if (c == '?') {
                if (indx < stringLength - 1 && Character.isDigit(sqlString.charAt(indx + 1))) {
                    right = StringHelper.firstIndexOfChar(sqlString, HQL_SEPARATORS, indx + 1);
                    chopLocation = right < 0 ? sqlString.length() : right;
                    param = sqlString.substring(indx + 1, chopLocation);
                    try {
                        recognizer.jpaPositionalParameter(Integer.parseInt(param), indx);
                        indx = chopLocation - 1;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ParameterLabelException("Ordinal parameter label was not an integer");
                    }
                }
                if (nativeJdbcParametersIgnored) continue;
                recognizer.ordinalParameter(indx);
                continue;
            }
            recognizer.other(c);
        }
        recognizer.complete();
    }

    public static void parse(String sqlString, ParameterRecognizer recognizer) throws QueryException {
        ParameterParser.parse(sqlString, recognizer, false);
    }

    private static void checkIsNotAFunctionCall(String sqlString) {
        String trimmed = sqlString.trim();
        if (!trimmed.startsWith("{") || !trimmed.endsWith("}")) {
            return;
        }
        int chopLocation = trimmed.indexOf("call");
        if (chopLocation <= 0) {
            return;
        }
        String checkString = trimmed.substring(1, chopLocation + 4);
        String fixture = "?=call";
        int fixturePosition = 0;
        boolean matches = true;
        int max = checkString.length();
        for (int i = 0; i < max; ++i) {
            char c = Character.toLowerCase(checkString.charAt(i));
            if (Character.isWhitespace(c)) continue;
            if (c == "?=call".charAt(fixturePosition)) {
                ++fixturePosition;
                continue;
            }
            matches = false;
            break;
        }
        if (matches) {
            throw new UnsupportedOperationException("Recognizing native query as a function call is no longer supported");
        }
    }

    static {
        for (int i = 0; i < HQL_SEPARATORS.length(); ++i) {
            HQL_SEPARATORS_BITSET.set(HQL_SEPARATORS.charAt(i));
        }
    }
}

