/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import io.meeds.social.space.constant.SpaceMembershipStatus;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.spi.ComponentAdapter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.ActiveIdentityFilter;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.IdentityWithRelationship;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.image.ImageUtils;
import org.exoplatform.social.core.jpa.search.ExtendProfileFilter;
import org.exoplatform.social.core.jpa.search.ProfileSearchConnector;
import org.exoplatform.social.core.jpa.storage.EntityConverterUtils;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl$AjcClosure1;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl$AjcClosure3;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl$AjcClosure5;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl$AjcClosure7;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.jpa.storage.dao.SpaceMemberDAO;
import org.exoplatform.social.core.jpa.storage.entity.ConnectionEntity;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity;
import org.exoplatform.social.core.jpa.storage.entity.ProfileExperienceEntity;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.model.BannerAttachment;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.IdentityStorageException;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.json.JSONArray;
import org.json.JSONObject;

public class RDBMSIdentityStorageImpl
implements IdentityStorage {
    private static final Log LOG;
    private static final int BATCH_SIZE = 100;
    private static final long MEGABYTE = 0x100000L;
    private static final String socialNameSpace = "social";
    private final IdentityDAO identityDAO;
    private final SpaceMemberDAO spaceMemberDAO;
    private final FileService fileService;
    private final OrganizationService orgService;
    private ProfileSearchConnector profileSearchConnector;
    private IdentityStorage cachedIdentityStorage;
    private ActivityStorage activityStorage;
    private SpaceStorage spaceStorage;
    private Map<String, IdentityProvider<?>> identityProviders = null;
    private int imageUploadLimit = 2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public RDBMSIdentityStorageImpl(IdentityDAO identityDAO, SpaceMemberDAO spaceMemberDAO, FileService fileService, OrganizationService orgService) {
        this.identityDAO = identityDAO;
        this.spaceMemberDAO = spaceMemberDAO;
        this.orgService = orgService;
        this.fileService = fileService;
    }

    private IdentityDAO getIdentityDAO() {
        return this.identityDAO;
    }

    public ProfileSearchConnector getProfileSearchConnector() {
        if (this.profileSearchConnector == null) {
            this.profileSearchConnector = (ProfileSearchConnector)CommonsUtils.getService(ProfileSearchConnector.class);
        }
        return this.profileSearchConnector;
    }

    public void setProfileSearchConnector(ProfileSearchConnector profileSearchConnector) {
        this.profileSearchConnector = profileSearchConnector;
    }

    private void mapToProfileEntity(Profile profile, IdentityEntity identityEntity) {
        String providerId;
        Map<String, String> entityProperties = identityEntity.getProperties();
        if (entityProperties == null) {
            entityProperties = new HashMap<String, String>();
        }
        if (!"organization".equals(providerId = profile.getIdentity().getProviderId()) && !"space".equals(providerId)) {
            entityProperties.put("Url", profile.getUrl());
        } else if ("organization".equals(providerId)) {
            profile.setProperty("fullName", (Object)profile.getFullName());
        }
        boolean hasBanner = false;
        boolean hasAvatar = false;
        Map properties = profile.getProperties();
        for (Map.Entry profileProperty : properties.entrySet()) {
            FileItem file;
            FileItem fileItem;
            Object fileName;
            Object bytes;
            AvatarAttachment attachment;
            if ("avatar".equalsIgnoreCase((String)profileProperty.getKey())) {
                hasAvatar = true;
                attachment = (AvatarAttachment)profileProperty.getValue();
                if (attachment == null || (bytes = attachment.getImageBytes()) == null || ((byte[])bytes).length == 0) continue;
                if ((long)((byte[])bytes).length / 0x100000L > (long)this.imageUploadLimit) {
                    throw new IdentityStorageException(IdentityStorageException.Type.AVATAR_EXCEEDS_LIMIT);
                }
                fileName = attachment.getFileName();
                if (fileName == null) {
                    fileName = identityEntity.getRemoteId() + "_avatar";
                }
                try {
                    Long avatarId = identityEntity.getAvatarFileId();
                    if (avatarId != null) {
                        fileItem = new FileItem(avatarId, (String)fileName, attachment.getMimeType(), socialNameSpace, (long)((Object)bytes).length, new Date(), identityEntity.getRemoteId(), false, (InputStream)new ByteArrayInputStream((byte[])bytes));
                        this.fileService.updateFile(fileItem);
                        continue;
                    }
                    fileItem = new FileItem(null, (String)fileName, attachment.getMimeType(), socialNameSpace, (long)((Object)bytes).length, new Date(), identityEntity.getRemoteId(), false, (InputStream)new ByteArrayInputStream((byte[])bytes));
                    fileItem = this.fileService.writeFile(fileItem);
                    identityEntity.setAvatarFileId(fileItem.getFileInfo().getId());
                }
                catch (Exception ex) {
                    LOG.error((Object)("Can not store avatar for " + identityEntity.getProviderId() + " " + identityEntity.getRemoteId()), (Throwable)ex);
                }
                continue;
            }
            if ("banner".equalsIgnoreCase((String)profileProperty.getKey())) {
                hasBanner = true;
                attachment = (BannerAttachment)profileProperty.getValue();
                if (attachment == null || (bytes = attachment.getImageBytes()) == null || ((byte[])bytes).length == 0) continue;
                if ((long)((byte[])bytes).length / 0x100000L > (long)this.imageUploadLimit) {
                    throw new IdentityStorageException(IdentityStorageException.Type.BANNER_EXCEEDS_LIMIT);
                }
                fileName = attachment.getFileName();
                if (fileName == null) {
                    fileName = identityEntity.getRemoteId() + "_banner";
                }
                try {
                    Long bannerId = identityEntity.getBannerFileId();
                    if (bannerId != null) {
                        fileItem = new FileItem(bannerId, (String)fileName, attachment.getMimeType(), socialNameSpace, (long)((Object)bytes).length, new Date(), identityEntity.getRemoteId(), false, (InputStream)new ByteArrayInputStream((byte[])bytes));
                        this.fileService.updateFile(fileItem);
                        continue;
                    }
                    fileItem = new FileItem(null, (String)fileName, attachment.getMimeType(), socialNameSpace, (long)((Object)bytes).length, new Date(), identityEntity.getRemoteId(), false, (InputStream)new ByteArrayInputStream((byte[])bytes));
                    fileItem = this.fileService.writeFile(fileItem);
                    identityEntity.setBannerFileId(fileItem.getFileInfo().getId());
                }
                catch (Exception ex) {
                    LOG.error((Object)("Can not store banner for " + identityEntity.getProviderId() + " " + identityEntity.getRemoteId()), (Throwable)ex);
                }
                continue;
            }
            if ("experiences".equalsIgnoreCase((String)profileProperty.getKey())) {
                List newExperiences = (List)profileProperty.getValue();
                identityEntity.getExperiences().clear();
                bytes = newExperiences.iterator();
                while (bytes.hasNext()) {
                    Map newExperience = (Map)bytes.next();
                    ProfileExperienceEntity profileExperienceEntity = new ProfileExperienceEntity();
                    profileExperienceEntity.setIdentity(identityEntity);
                    String experienceId = (String)newExperience.get("id");
                    if (StringUtils.isNotBlank((CharSequence)experienceId)) {
                        profileExperienceEntity.setId(Long.valueOf(experienceId));
                    }
                    profileExperienceEntity.setCompany((String)newExperience.get("company"));
                    profileExperienceEntity.setPosition((String)newExperience.get("position"));
                    profileExperienceEntity.setStartDate((String)newExperience.get("startDate"));
                    profileExperienceEntity.setEndDate((String)newExperience.get("endDate"));
                    profileExperienceEntity.setSkills((String)newExperience.get("skills"));
                    profileExperienceEntity.setDescription((String)newExperience.get("description"));
                    identityEntity.getExperiences().add(profileExperienceEntity);
                }
                continue;
            }
            if ("ims".equals(profileProperty.getKey()) || "phones".equals(profileProperty.getKey()) || "urls".equals(profileProperty.getKey()) || properties.get(profileProperty.getKey()) instanceof ArrayList) {
                List list = (List)profileProperty.getValue();
                JSONArray arr = new JSONArray();
                for (Map map : list) {
                    JSONObject json = new JSONObject(map);
                    arr.put((Object)json);
                }
                entityProperties.put((String)profileProperty.getKey(), arr.toString());
                continue;
            }
            if ("skills".equals(profileProperty.getKey())) continue;
            Object val = profileProperty.getValue();
            if ((profile.getIdentity().isUser() || profile.getIdentity().isSpace()) && ("firstName".equalsIgnoreCase((String)profileProperty.getKey()) || "lastName".equalsIgnoreCase((String)profileProperty.getKey()) || "fullName".equalsIgnoreCase((String)profileProperty.getKey())) && profileProperty.getValue() != null && !profileProperty.getValue().equals(entityProperties.get(profileProperty.getKey())) && identityEntity.getAvatarFileId() != null && (file = this.getRDBMSCachedIdentityStorage().getAvatarFile(profile.getIdentity())) != null && "DEFAULT_AVATAR".equals(file.getFileInfo().getName())) {
                this.fileService.deleteFile(file.getFileInfo().getId().longValue());
                identityEntity.setAvatarFileId(null);
            }
            entityProperties.put((String)profileProperty.getKey(), val != null ? String.valueOf(val) : null);
        }
        if (identityEntity.getBannerFileId() != null && !hasBanner && profile.getBannerUrl() == null) {
            this.fileService.deleteFile(identityEntity.getBannerFileId().longValue());
            identityEntity.setBannerFileId(null);
        }
        if (identityEntity.getAvatarFileId() != null && !hasAvatar && profile.getAvatarUrl() == null) {
            this.fileService.deleteFile(identityEntity.getAvatarFileId().longValue());
            identityEntity.setAvatarFileId(null);
        }
        entityProperties.entrySet().removeIf(p -> profile.getProperty((String)p.getKey()) == null);
        identityEntity.setProperties(entityProperties);
        Date created = profile.getCreatedTime() <= 0L ? new Date() : new Date(profile.getCreatedTime());
        identityEntity.setCreatedDate(created);
    }

    public void saveIdentity(Identity identity) throws IdentityStorageException {
        long id = EntityConverterUtils.parseId(identity.getId());
        IdentityEntity entity = null;
        entity = id > 0L ? (IdentityEntity)this.getIdentityDAO().find(Long.valueOf(id)) : this.getIdentityDAO().findByProviderAndRemoteId(identity.getProviderId(), identity.getRemoteId());
        if (entity == null) {
            entity = new IdentityEntity();
        }
        EntityConverterUtils.mapToEntity(identity, entity);
        if (entity.getId() > 0L) {
            this.getIdentityDAO().update(entity);
        } else {
            if (identity.getProfile() != null) {
                this.mapToProfileEntity(identity.getProfile(), entity);
            }
            entity = (IdentityEntity)this.getIdentityDAO().create(entity);
        }
        Profile profile = EntityConverterUtils.convertToProfile(entity, identity);
        if (id <= 0L) {
            profile.setId(null);
        }
        identity.setProfile(profile);
        identity.setId(entity.getStringId());
    }

    public Identity updateIdentity(Identity identity) throws IdentityStorageException {
        long id = EntityConverterUtils.parseId(identity.getId());
        IdentityEntity entity = null;
        if (id > 0L) {
            entity = (IdentityEntity)this.getIdentityDAO().find(Long.valueOf(id));
        }
        if (entity == null) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_UPDATE_IDENTITY, "The identity does not exist on DB");
        }
        EntityConverterUtils.mapToEntity(identity, entity);
        entity = (IdentityEntity)this.getIdentityDAO().update(entity);
        return EntityConverterUtils.convertToIdentity(entity, true);
    }

    public void updateIdentityMembership(String remoteId) throws IdentityStorageException {
    }

    public Identity findIdentityById(String nodeId) throws IdentityStorageException {
        long id = EntityConverterUtils.parseId(nodeId);
        IdentityEntity entity = (IdentityEntity)this.getIdentityDAO().find(Long.valueOf(id));
        if (entity != null) {
            return EntityConverterUtils.convertToIdentity(entity);
        }
        return null;
    }

    public void deleteIdentity(Identity identity) throws IdentityStorageException {
        this.hardDeleteIdentity(identity);
    }

    @ExoTransactional
    public void hardDeleteIdentity(Identity identity) throws IdentityStorageException {
        Identity identity2 = identity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)identity2);
        Object[] objectArray = new Object[]{this, identity2, joinPoint};
        RDBMSIdentityStorageImpl$AjcClosure1 rDBMSIdentityStorageImpl$AjcClosure1 = new RDBMSIdentityStorageImpl$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(rDBMSIdentityStorageImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public Profile loadProfile(Profile profile) throws IdentityStorageException {
        Profile profile2 = profile;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)profile2);
        Object[] objectArray = new Object[]{this, profile2, joinPoint};
        RDBMSIdentityStorageImpl$AjcClosure3 rDBMSIdentityStorageImpl$AjcClosure3 = new RDBMSIdentityStorageImpl$AjcClosure3(objectArray);
        return (Profile)ExoTransactionalAspect.aspectOf().around(rDBMSIdentityStorageImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public Identity findIdentity(String providerId, String remoteId) throws IdentityStorageException {
        try {
            IdentityEntity entity = this.getIdentityDAO().findByProviderAndRemoteId(providerId, remoteId);
            if (entity == null) {
                return null;
            }
            return EntityConverterUtils.convertToIdentity(entity);
        }
        catch (Exception ex) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_FIND_IDENTITY, "Can not load identity", (Throwable)ex);
        }
    }

    public String findIdentityId(String providerId, String remoteId) throws IdentityStorageException {
        Long identityId = this.getIdentityDAO().findIdByProviderAndRemoteId(providerId, remoteId);
        return identityId == null ? null : String.valueOf(identityId);
    }

    public void saveProfile(Profile profile) throws IdentityStorageException {
        IdentityEntity entity;
        long id = EntityConverterUtils.parseId(profile.getIdentity().getId());
        IdentityEntity identityEntity = entity = id == 0L ? null : (IdentityEntity)this.identityDAO.find(Long.valueOf(id));
        if (entity == null) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_UPDATE_PROFILE, "Profile does not exist on RDBMS");
        }
        this.mapToProfileEntity(profile, entity);
        this.identityDAO.update(entity);
        profile.setId(entity.getStringId());
        profile.clearHasChanged();
    }

    @ExoTransactional
    public void updateProfile(Profile profile) throws IdentityStorageException {
        Profile profile2 = profile;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)profile2);
        Object[] objectArray = new Object[]{this, profile2, joinPoint};
        RDBMSIdentityStorageImpl$AjcClosure5 rDBMSIdentityStorageImpl$AjcClosure5 = new RDBMSIdentityStorageImpl$AjcClosure5(objectArray);
        ExoTransactionalAspect.aspectOf().around(rDBMSIdentityStorageImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    public int getIdentitiesCount(String providerId) throws IdentityStorageException {
        return (int)this.getIdentityDAO().countIdentityByProvider(providerId);
    }

    public void addOrModifyProfileProperties(Profile profile) throws IdentityStorageException {
        this.updateProfile(profile);
    }

    public void updateProfileActivityId(Identity identity, String activityId, Profile.AttachedActivityType type) {
    }

    public String getProfileActivityId(Profile profile, Profile.AttachedActivityType type) {
        String t = "SPACE_ACTIVITY";
        if (type == Profile.AttachedActivityType.USER) {
            t = "USER_PROFILE_ACTIVITY";
        } else if (type == Profile.AttachedActivityType.RELATIONSHIP) {
            t = "USER_ACTIVITIES_FOR_RELATIONSHIP";
        }
        List activitiesByPoster = this.getActivityStorage().getActivitiesByPoster(profile.getIdentity(), 0, 1, new String[]{t});
        if (activitiesByPoster != null && activitiesByPoster.size() > 0) {
            return String.valueOf(((ExoSocialActivity)activitiesByPoster.get(0)).getId());
        }
        return null;
    }

    public Set<String> getActiveUsers(ActiveIdentityFilter filter) {
        HashSet<String> activeUsers = new HashSet<String>();
        if (filter.getUserGroups() != null) {
            StringTokenizer stringToken = new StringTokenizer(filter.getUserGroups(), ",");
            try {
                while (stringToken.hasMoreTokens()) {
                    try {
                        User[] users;
                        ListAccess listAccess = this.orgService.getUserHandler().findUsersByGroupId(stringToken.nextToken().trim());
                        for (User u : users = (User[])listAccess.load(0, listAccess.getSize())) {
                            activeUsers.add(u.getUserName());
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage());
            }
        }
        if (CommonsUtils.getService(UserStateService.class) != null) {
            List onlines = ((UserStateService)CommonsUtils.getService(UserStateService.class)).online();
            for (UserStateModel user : onlines) {
                activeUsers.add(user.getUserId());
            }
        }
        return activeUsers;
    }

    public void processEnabledIdentity(Identity identity, boolean isEnable) {
        long id = EntityConverterUtils.parseId(identity.getId());
        IdentityEntity entity = (IdentityEntity)this.getIdentityDAO().find(Long.valueOf(id));
        if (entity == null) {
            throw new IllegalArgumentException("Identity does not exists");
        }
        entity.setEnabled(isEnable);
        this.getIdentityDAO().update(entity);
    }

    public List<Identity> getIdentitiesForMentions(String providerId, ProfileFilter profileFilter, Relationship.Type type, long offset, long limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        Identity identity = null;
        if (profileFilter.getViewerIdentity() != null) {
            identity = profileFilter.getViewerIdentity();
        }
        if ("organization".equals(providerId)) {
            return this.getProfileSearchConnector().search(identity, profileFilter, type, offset, limit).stream().map(arg_0 -> ((IdentityStorage)this.getRDBMSCachedIdentityStorage()).findIdentityById(arg_0)).toList();
        }
        throw new IllegalStateException("Can't search identities with provider id = " + providerId);
    }

    public int getIdentitiesForMentionsCount(String providerId, ProfileFilter profileFilter, Relationship.Type type) throws IdentityStorageException {
        Identity identity = null;
        if (profileFilter.getViewerIdentity() != null) {
            identity = profileFilter.getViewerIdentity();
        }
        if ("organization".equals(providerId)) {
            return this.getProfileSearchConnector().count(identity, profileFilter, type);
        }
        throw new IllegalStateException("Can't search identities with provider id = " + providerId);
    }

    public int getIdentitiesByProfileFilterCount(String providerId, ProfileFilter profileFilter) throws IdentityStorageException {
        return this.getIdentityDAO().getAllIdsCountByProvider(providerId, profileFilter.getUserType(), profileFilter.isConnected(), profileFilter.isEnabled(), profileFilter.getEnrollmentStatus());
    }

    public List<Identity> getIdentitiesForUnifiedSearch(String providerId, ProfileFilter profileFilter, long offset, long limit) throws IdentityStorageException {
        return this.getProfileSearchConnector().search(null, profileFilter, null, offset, limit).stream().map(arg_0 -> ((IdentityStorage)this.getRDBMSCachedIdentityStorage()).findIdentityById(arg_0)).toList();
    }

    public List<Identity> getSpaceMemberIdentitiesByProfileFilter(Space space, ProfileFilter profileFilter, SpaceMemberFilterListAccess.Type type, long offset, long limit) throws IdentityStorageException {
        List<String> spaceMembers;
        if (space == null) {
            throw new IllegalArgumentException("Space shouldn't be null");
        }
        Sorting sorting = profileFilter.getSorting();
        String sortFieldName = sorting == null || sorting.sortBy == null ? null : sorting.sortBy.getFieldName();
        String sortDirection = sorting == null || sorting.sortBy == null ? null : sorting.orderBy.name();
        ArrayList<String> excludedMembers = new ArrayList<String>();
        if (profileFilter.getExcludedIdentityList() != null) {
            for (Identity identity : profileFilter.getExcludedIdentityList()) {
                excludedMembers.add(identity.getRemoteId());
            }
        }
        SpaceMembershipStatus status = null;
        if (!SpaceMemberFilterListAccess.Type.DISABLED.equals((Object)type)) {
            switch (type) {
                case MANAGER: {
                    status = SpaceMembershipStatus.MANAGER;
                    break;
                }
                case REDACTOR: {
                    status = SpaceMembershipStatus.REDACTOR;
                    break;
                }
                case PUBLISHER: {
                    status = SpaceMembershipStatus.PUBLISHER;
                    break;
                }
                case INVITED: {
                    status = SpaceMembershipStatus.INVITED;
                    break;
                }
                case PENDING: {
                    status = SpaceMembershipStatus.PENDING;
                    break;
                }
                default: {
                    status = SpaceMembershipStatus.MEMBER;
                }
            }
            spaceMembers = this.getSpaceMembers(space.getId(), status);
        } else {
            spaceMembers = this.getDisabledSpaceMembers(Long.parseLong(space.getId()));
        }
        List remoteIds = profileFilter.getRemoteIds();
        spaceMembers = spaceMembers.stream().filter(username -> !excludedMembers.contains(username) && (CollectionUtils.isEmpty((Collection)remoteIds) || remoteIds.contains(username))).distinct().toList();
        if (profileFilter.getExcludedIdentityList() != null) {
            for (Identity identity : profileFilter.getExcludedIdentityList()) {
                spaceMembers.remove(identity.getRemoteId());
            }
        }
        if (spaceMembers.isEmpty()) {
            return Collections.emptyList();
        }
        if (profileFilter.isEmpty() || SpaceMemberFilterListAccess.Type.DISABLED.equals((Object)type)) {
            ArrayList<Identity> identities = new ArrayList<Identity>();
            if (spaceMembers.size() > 1) {
                spaceMembers = this.sortIdentities(spaceMembers, sortFieldName, sortDirection, false);
            }
            int i = (int)offset;
            long indexLimit = offset + limit;
            while (i < spaceMembers.size() && (long)i < indexLimit) {
                String spaceMemberUserName;
                Identity identity;
                if ((identity = this.getOrCreateUserIdentityUsingCache("organization", spaceMemberUserName = spaceMembers.get(i++))) == null) continue;
                identities.add(identity);
            }
            return identities;
        }
        try {
            profileFilter = profileFilter.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.warn((Object)"Error while cloning profile filter", (Throwable)e);
        }
        profileFilter.setRemoteIds(spaceMembers);
        return this.getProfileSearchConnector().search(null, profileFilter, null, offset, limit).stream().map(arg_0 -> ((IdentityStorage)this.getRDBMSCachedIdentityStorage()).findIdentityById(arg_0)).toList();
    }

    public int countSpaceMemberIdentitiesByProfileFilter(Space space, ProfileFilter profileFilter, SpaceMemberFilterListAccess.Type type) {
        if (space == null) {
            throw new IllegalArgumentException("Space shouldn't be null");
        }
        ArrayList<String> excludedMembers = new ArrayList<String>();
        if (profileFilter != null && profileFilter.getExcludedIdentityList() != null) {
            for (Identity identity : profileFilter.getExcludedIdentityList()) {
                excludedMembers.add(identity.getRemoteId());
            }
        }
        List<String> spaceMembers = null;
        switch (type) {
            case INVITED: {
                if (space.getInvitedUsers() == null || space.getInvitedUsers().length == 0) {
                    return 0;
                }
                spaceMembers = Arrays.stream(space.getInvitedUsers()).filter(username -> !excludedMembers.contains(username)).toList();
                break;
            }
            case PENDING: {
                if (space.getPendingUsers() == null || space.getPendingUsers().length == 0) {
                    return 0;
                }
                spaceMembers = Arrays.stream(space.getPendingUsers()).filter(username -> !excludedMembers.contains(username)).toList();
                break;
            }
            case MANAGER: {
                if (space.getManagers() == null || space.getManagers().length == 0) {
                    return 0;
                }
                spaceMembers = Arrays.stream(space.getManagers()).filter(username -> !excludedMembers.contains(username)).toList();
                break;
            }
            case REDACTOR: {
                if (space.getRedactors() == null || space.getRedactors().length == 0) {
                    return 0;
                }
                spaceMembers = Arrays.stream(space.getRedactors()).filter(username -> !excludedMembers.contains(username)).toList();
                break;
            }
            case PUBLISHER: {
                if (space.getPublishers() == null || space.getPublishers().length == 0) {
                    return 0;
                }
                spaceMembers = Arrays.stream(space.getPublishers()).filter(username -> !excludedMembers.contains(username)).toList();
                break;
            }
            default: {
                if (space.getMembers() == null || space.getMembers().length == 0) {
                    return 0;
                }
                spaceMembers = Arrays.stream(space.getMembers()).filter(username -> !excludedMembers.contains(username)).toList();
            }
        }
        if (profileFilter == null || profileFilter.isEmpty()) {
            return spaceMembers.size();
        }
        try {
            profileFilter = profileFilter.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.warn((Object)"Error while cloning profile filter", (Throwable)e);
        }
        profileFilter.setRemoteIds(spaceMembers);
        return this.getProfileSearchConnector().count(null, profileFilter, null);
    }

    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter, long offset, long limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        ExtendProfileFilter xFilter = new ExtendProfileFilter(profileFilter);
        xFilter.setProviderId(providerId);
        xFilter.setForceLoadProfile(forceLoadOrReloadProfile);
        ListAccess<IdentityEntity> list = this.getIdentityDAO().findIdentities(xFilter);
        return EntityConverterUtils.convertToIdentities(list, offset, limit);
    }

    public List<Identity> getIdentities(String providerId, String sortField, String sortDirection, boolean isEnabled, String userType, Boolean isConnected, String enrollmentStatus, long offset, long limit) {
        List<String> usernames = this.getIdentityDAO().getAllIdsByProviderSorted(providerId, sortField, sortDirection, isEnabled, userType, isConnected, enrollmentStatus, offset, limit);
        ArrayList<Identity> identities = new ArrayList<Identity>();
        if (usernames != null && !usernames.isEmpty()) {
            for (String username : usernames) {
                Identity identity = this.getOrCreateUserIdentityUsingCache(providerId, username);
                if (identity == null) continue;
                identities.add(identity);
            }
        }
        return identities;
    }

    public List<String> getIdentityIds(String providerId, String sortField, String sortDirection, boolean isEnabled, String userType, Boolean isConnected, String enrollmentStatus, long offset, long limit) {
        return this.getIdentityDAO().getIdentityIdsByProviderSorted(providerId, sortField, sortDirection, isEnabled, userType, isConnected, enrollmentStatus, offset, limit).stream().map(String::valueOf).toList();
    }

    public List<Identity> getIdentities(String providerId, long offset, long limit) throws IdentityStorageException {
        return this.getIdentities(providerId, null, null, true, null, null, null, offset, limit);
    }

    public List<IdentityWithRelationship> getIdentitiesWithRelationships(String identityId, int offset, int limit) throws IdentityStorageException {
        return this.getIdentitiesWithRelationships(identityId, null, null, offset, limit);
    }

    public List<IdentityWithRelationship> getIdentitiesWithRelationships(String identityId, String sortFieldName, String sortDirection, int offset, int limit) {
        ListAccess<Map.Entry<IdentityEntity, ConnectionEntity>> list = this.getIdentityDAO().findAllIdentitiesWithConnections(Long.valueOf(identityId), sortFieldName, sortDirection);
        return EntityConverterUtils.convertToIdentitiesWithRelationship(list, offset, limit);
    }

    public int countIdentitiesWithRelationships(String identityId) throws Exception {
        ListAccess<Map.Entry<IdentityEntity, ConnectionEntity>> list = this.getIdentityDAO().findAllIdentitiesWithConnections(Long.valueOf(identityId), null, null);
        return list.getSize();
    }

    public ListAccess<Identity> findByFilter(ExtendProfileFilter filter) {
        final ListAccess<IdentityEntity> list = this.getIdentityDAO().findIdentities(filter);
        return new ListAccess<Identity>(){

            public Identity[] load(int offset, int size) throws Exception, IllegalArgumentException {
                IdentityEntity[] entities = (IdentityEntity[])list.load(offset, size);
                if (entities == null || entities.length == 0) {
                    return new Identity[0];
                }
                Identity[] identities = new Identity[entities.length];
                for (int i = 0; i < entities.length; ++i) {
                    identities[i] = EntityConverterUtils.convertToIdentity(entities[i]);
                }
                return identities;
            }

            public int getSize() throws Exception {
                return list.getSize();
            }
        };
    }

    @ExoTransactional
    public void removeIdentity(Identity identity) {
        Identity identity2 = identity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)identity2);
        Object[] objectArray = new Object[]{this, identity2, joinPoint};
        RDBMSIdentityStorageImpl$AjcClosure7 rDBMSIdentityStorageImpl$AjcClosure7 = new RDBMSIdentityStorageImpl$AjcClosure7(objectArray);
        ExoTransactionalAspect.aspectOf().around(rDBMSIdentityStorageImpl$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    public InputStream getAvatarInputStreamById(Identity identity) throws IOException {
        FileItem fileItem = this.getAvatarFile(identity);
        if (fileItem != null) {
            return fileItem.getAsStream();
        }
        return null;
    }

    public FileItem getAvatarFile(Identity identity) {
        FileItem file = null;
        IdentityEntity entity = this.identityDAO.findByProviderAndRemoteId(identity.getProviderId(), identity.getRemoteId());
        if (entity != null) {
            if (entity.getAvatarFileId() != null) {
                file = this.fileService.getFile(entity.getAvatarFileId().longValue());
            } else if (identity.isUser() || identity.isSpace()) {
                String fullNameAbbreviation = this.getNameAbbreviation(identity);
                AvatarAttachment avatar = ImageUtils.createDefaultAvatar(identity.getId(), fullNameAbbreviation);
                if (avatar != null) {
                    byte[] bytes = avatar.getImageBytes();
                    file = new FileItem(null, "DEFAULT_AVATAR", avatar.getMimeType(), socialNameSpace, (long)bytes.length, new Date(), identity.getRemoteId(), false, (InputStream)new ByteArrayInputStream(bytes));
                    file = this.fileService.writeFile(file);
                    entity.setAvatarFileId(file.getFileInfo().getId());
                    this.identityDAO.update(entity);
                }
            }
        }
        return file;
    }

    public InputStream getBannerInputStreamById(Identity identity) throws IOException {
        FileItem file = null;
        IdentityEntity entity = this.identityDAO.findByProviderAndRemoteId(identity.getProviderId(), identity.getRemoteId());
        if (entity == null) {
            return null;
        }
        Long bannerId = entity.getBannerFileId();
        if (bannerId == null) {
            return null;
        }
        try {
            file = this.fileService.getFile(bannerId.longValue());
        }
        catch (FileStorageException e) {
            return null;
        }
        if (file == null) {
            return null;
        }
        return file.getAsStream();
    }

    private List<String> getSpaceMembers(String spaceIdString, SpaceMembershipStatus status) {
        long spaceId = Long.parseLong(spaceIdString);
        int countSpaceMembers = this.spaceMemberDAO.countSpaceMembers(spaceId, status);
        if (countSpaceMembers == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> members = new ArrayList<String>();
        for (int offset = 0; offset < countSpaceMembers; offset += 100) {
            List<String> spaceMembers = this.spaceMemberDAO.getSpaceMembers(spaceId, status, offset, 100);
            for (String username : spaceMembers) {
                members.add(username);
            }
        }
        return members;
    }

    public List<String> getDisabledSpaceMembers(Long spaceId) {
        int countSpaceMembers = this.spaceMemberDAO.countDisabledSpaceMembers(spaceId);
        if (countSpaceMembers == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> members = new ArrayList<String>();
        for (int offset = 0; offset < countSpaceMembers; offset += 100) {
            List<String> spaceMembers = this.spaceMemberDAO.getDisabledSpaceMembers(spaceId, offset, 100);
            for (String username : spaceMembers) {
                members.add(username);
            }
        }
        return members;
    }

    public IdentityProvider<?> getIdentityProvider(String providerId) {
        if (this.identityProviders == null || this.identityProviders.isEmpty()) {
            this.identityProviders = new HashMap();
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            if (container == null) {
                container = PortalContainer.getInstance();
            }
            for (ComponentAdapter componentAdapter : container.getComponentAdaptersOfType(IdentityProvider.class)) {
                if (componentAdapter == null) continue;
                Object key = componentAdapter.getComponentKey();
                IdentityProvider service = (IdentityProvider)container.getComponentInstance(key);
                this.identityProviders.put(service.getName(), service);
            }
        }
        return this.identityProviders.get(providerId);
    }

    public IdentityStorage getRDBMSCachedIdentityStorage() {
        if (this.cachedIdentityStorage == null) {
            this.cachedIdentityStorage = (IdentityStorage)CommonsUtils.getService(IdentityStorage.class);
        }
        return this.cachedIdentityStorage;
    }

    public ActivityStorage getActivityStorage() {
        if (this.activityStorage == null) {
            this.activityStorage = (ActivityStorage)CommonsUtils.getService(ActivityStorage.class);
        }
        return this.activityStorage;
    }

    public SpaceStorage getSpaceStorage() {
        if (this.spaceStorage == null) {
            this.spaceStorage = (SpaceStorage)CommonsUtils.getService(SpaceStorage.class);
        }
        return this.spaceStorage;
    }

    private Identity getOrCreateUserIdentityUsingCache(String providerId, String userId) {
        Identity identity = this.getRDBMSCachedIdentityStorage().findIdentity(providerId, userId);
        if (identity == null) {
            identity = this.getIdentityProvider(providerId).getIdentityByRemoteId(userId);
            if (identity == null) {
                LOG.warn("Can't find identity for space member '{}'. The identity will not be retrieved.", new Object[]{userId});
            } else {
                LOG.info("User identity for space member '{}' wasn't found. Creating the identity.", new Object[]{userId});
                try {
                    this.saveIdentity(identity);
                    this.saveProfile(identity.getProfile());
                }
                catch (Exception e) {
                    LOG.warn((Object)("Can't create user identity for space member '" + userId + "'. The identity will not be retrieved."), (Throwable)e);
                    identity = null;
                }
            }
        }
        return identity;
    }

    public List<String> sortIdentities(List<String> identityRemoteIds, String sortField, String sortDirection) {
        return this.sortIdentities(identityRemoteIds, sortField, sortDirection, true);
    }

    public List<String> sortIdentities(List<String> identityRemoteIds, String sortField, String sortDirection, boolean filterDisabled) {
        return this.spaceMemberDAO.sortSpaceMembers(identityRemoteIds, sortField, sortDirection, filterDisabled);
    }

    public void setImageUploadLimit(int imageUploadLimit) {
        this.imageUploadLimit = imageUploadLimit;
    }

    private String getNameAbbreviation(Identity identity) {
        Space space;
        String name = "";
        if (identity.isUser()) {
            name = identity.getProfile().getFullName();
        } else if (identity.isSpace() && StringUtils.isBlank((CharSequence)(name = identity.getProfile().getFullName())) && (space = this.getSpaceStorage().getSpaceByPrettyName(identity.getRemoteId())) != null) {
            name = space.getDisplayName();
            identity.getProfile().setProperty("fullName", (Object)name);
            this.updateProfile(identity.getProfile());
        }
        String result = name.replaceAll("\\B.|\\P{L}", "").toUpperCase();
        if (result.length() > 2) {
            return result.substring(0, 2);
        }
        return result;
    }

    static {
        RDBMSIdentityStorageImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(RDBMSIdentityStorageImpl.class);
    }

    static /* synthetic */ void hardDeleteIdentity_aroundBody0(RDBMSIdentityStorageImpl ajc$this, Identity identity, JoinPoint joinPoint) {
        long id = EntityConverterUtils.parseId(identity.getId());
        String username = identity.getRemoteId();
        String provider = identity.getProviderId();
        IdentityEntity entity = (IdentityEntity)ajc$this.getIdentityDAO().find(Long.valueOf(id));
        if (entity != null) {
            entity.setDeleted(true);
            ajc$this.getIdentityDAO().update(entity);
            if (entity.getAvatarFileId() != null && entity.getAvatarFileId() > 0L) {
                ajc$this.fileService.deleteFile(entity.getAvatarFileId().longValue());
            }
            if (entity.getBannerFileId() != null && entity.getBannerFileId() > 0L) {
                ajc$this.fileService.deleteFile(entity.getBannerFileId().longValue());
            }
        }
        EntityManager em = ((EntityManagerService)CommonsUtils.getService(EntityManagerService.class)).getEntityManager();
        Query query = em.createNamedQuery("SocConnection.deleteConnectionByIdentity");
        query.setParameter("identityId", (Object)id);
        query.executeUpdate();
        if ("organization".equals(provider)) {
            query = em.createNamedQuery("SpaceMember.deleteByUsername");
            query.setParameter("username", (Object)username);
            query.executeUpdate();
        }
    }

    static /* synthetic */ Profile loadProfile_aroundBody2(RDBMSIdentityStorageImpl ajc$this, Profile profile, JoinPoint joinPoint) {
        FileItem fileItem;
        long identityId = EntityConverterUtils.parseId(profile.getIdentity().getId());
        IdentityEntity entity = (IdentityEntity)ajc$this.identityDAO.find(Long.valueOf(identityId));
        if (entity == null) {
            return null;
        }
        profile.setId(String.valueOf(entity.getId()));
        if (entity.getAvatarFileId() != null && entity.getAvatarFileId() > 0L && (fileItem = ajc$this.fileService.getFile(entity.getAvatarFileId().longValue())) != null) {
            profile.setDefaultAvatar("DEFAULT_AVATAR".equals(fileItem.getFileInfo().getName()));
        }
        EntityConverterUtils.mapToProfile(entity, profile);
        profile.clearHasChanged();
        return profile;
    }

    static /* synthetic */ void updateProfile_aroundBody4(RDBMSIdentityStorageImpl ajc$this, Profile profile, JoinPoint joinPoint) {
        long id = EntityConverterUtils.parseId(profile.getIdentity().getId());
        IdentityEntity entity = (IdentityEntity)ajc$this.identityDAO.find(Long.valueOf(id));
        if (entity == null) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_UPDATE_PROFILE, "Profile does not exist on RDBMS");
        }
        ajc$this.mapToProfileEntity(profile, entity);
        if ("DEFAULT_BANNER".equals(profile.getBannerUrl())) {
            entity.setBannerFileId(null);
        }
        ajc$this.identityDAO.update(entity);
    }

    static /* synthetic */ void removeIdentity_aroundBody6(RDBMSIdentityStorageImpl ajc$this, Identity identity, JoinPoint joinPoint) {
        long id = EntityConverterUtils.parseId(identity.getId());
        String username = identity.getRemoteId();
        String provider = identity.getProviderId();
        IdentityEntity entity = (IdentityEntity)ajc$this.getIdentityDAO().find(Long.valueOf(id));
        EntityManager em = ((EntityManagerService)CommonsUtils.getService(EntityManagerService.class)).getEntityManager();
        Query query = em.createNamedQuery("SocConnection.deleteConnectionByIdentity");
        query.setParameter("identityId", (Object)id);
        query.executeUpdate();
        if ("organization".equals(provider)) {
            query = em.createNamedQuery("SpaceMember.deleteByUsername");
            query.setParameter("username", (Object)username);
            query.executeUpdate();
        }
        if (entity != null) {
            ajc$this.getIdentityDAO().delete(entity);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RDBMSIdentityStorageImpl.java", RDBMSIdentityStorageImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hardDeleteIdentity", "org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl", "org.exoplatform.social.core.identity.model.Identity", "identity", "org.exoplatform.social.core.storage.IdentityStorageException", "void"), 454);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "loadProfile", "org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl", "org.exoplatform.social.core.identity.model.Profile", "profile", "org.exoplatform.social.core.storage.IdentityStorageException", "org.exoplatform.social.core.identity.model.Profile"), 496);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateProfile", "org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl", "org.exoplatform.social.core.identity.model.Profile", "profile", "org.exoplatform.social.core.storage.IdentityStorageException", "void"), 572);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeIdentity", "org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl", "org.exoplatform.social.core.identity.model.Identity", "identity", "", "void"), 1035);
    }
}

