/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.portal.security.listener;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.portal.security.constant.UserRegistrationType;
import io.meeds.portal.security.listener.DefaultUserMembershipListener$AjcClosure1;
import io.meeds.portal.security.service.SecuritySettingService;
import java.util.Calendar;
import java.util.Collection;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;

public class DefaultUserMembershipListener
extends Listener<ConversationRegistry, ConversationState> {
    private static final Log LOG;
    private static final String INTERNAL_USERS_GROUP = "/platform/users";
    private static final String USER_PROFILE = "UserProfile";
    private static final String MEMBER_MT = "member";
    private ExoContainer container;
    private SecuritySettingService securitySettingService;
    private OrganizationService organizationService;
    private IdentityRegistry identityRegistry;
    private ConversationRegistry conversationRegistry;
    private Authenticator authenticator;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public DefaultUserMembershipListener(ExoContainer container) {
        this.container = container;
    }

    @ContainerTransactional
    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        Event<ConversationRegistry, ConversationState> event2 = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), event2);
        Object[] objectArray = new Object[]{this, event2, joinPoint};
        DefaultUserMembershipListener$AjcClosure1 defaultUserMembershipListener$AjcClosure1 = new DefaultUserMembershipListener$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(defaultUserMembershipListener$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private boolean isFirstTimeLogin(User user) {
        return user.getLastLoginTime() == null || Math.abs(user.getLastLoginTime().getTime() - user.getCreatedDate().getTime()) < 1000L;
    }

    private boolean allowToAddToDefaultGroups(User user) throws Exception {
        return this.securitySettingService.getRegistrationType() == UserRegistrationType.OPEN || this.isInternalUser(user);
    }

    private boolean isInternalUser(User user) throws Exception {
        Collection memberships = this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(user.getUserName(), INTERNAL_USERS_GROUP);
        return CollectionUtils.isNotEmpty((Collection)memberships);
    }

    private void addUserToDefaultGroups(User user) throws Exception {
        MembershipType memberMembershipType = this.organizationService.getMembershipTypeHandler().findMembershipType(MEMBER_MT);
        for (String groupId : this.securitySettingService.getRegistrationGroupIds()) {
            Group group = this.organizationService.getGroupHandler().findGroupById(groupId);
            if (group == null) {
                LOG.warn("Group with id {} wasn't found, the newly logged in user will not be added into it", new Object[]{groupId});
                continue;
            }
            Membership membership = this.organizationService.getMembershipHandler().findMembershipByUserGroupAndType(user.getUserName(), groupId, MEMBER_MT);
            if (membership != null) continue;
            this.organizationService.getMembershipHandler().linkMembership(user, group, memberMembershipType, true);
        }
    }

    private User getUser(ConversationState state) throws Exception {
        User user = (User)state.getAttribute(USER_PROFILE);
        if (user == null) {
            user = this.organizationService.getUserHandler().findUserByName(state.getIdentity().getUserId());
            state.setAttribute(USER_PROFILE, (Object)user);
        }
        return user;
    }

    static {
        DefaultUserMembershipListener.ajc$preClinit();
        LOG = ExoLogger.getLogger(DefaultUserMembershipListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final /* synthetic */ void onEvent_aroundBody0(DefaultUserMembershipListener ajc$this, Event event, JoinPoint joinPoint) {
        ConversationState state;
        if (ajc$this.organizationService == null) {
            ajc$this.organizationService = (OrganizationService)ajc$this.container.getComponentInstanceOfType(OrganizationService.class);
        }
        if (ajc$this.securitySettingService == null) {
            ajc$this.securitySettingService = (SecuritySettingService)ajc$this.container.getComponentInstanceOfType(SecuritySettingService.class);
        }
        if (ajc$this.identityRegistry == null) {
            ajc$this.identityRegistry = (IdentityRegistry)ajc$this.container.getComponentInstanceOfType(IdentityRegistry.class);
        }
        if (ajc$this.conversationRegistry == null) {
            ajc$this.conversationRegistry = (ConversationRegistry)ajc$this.container.getComponentInstanceOfType(ConversationRegistry.class);
        }
        if (ajc$this.authenticator == null) {
            ajc$this.authenticator = (Authenticator)ajc$this.container.getComponentInstanceOfType(Authenticator.class);
        }
        if ((state = (ConversationState)event.getData()) == null || state.getIdentity() == null || state.getIdentity().getUserId() == null || StringUtils.equals((CharSequence)state.getIdentity().getUserId(), (CharSequence)IdentityConstants.ANONIM)) {
            return;
        }
        User user = ajc$this.getUser(state);
        if (user != null) {
            String username = user.getUserName();
            try {
                if (ajc$this.isFirstTimeLogin(user) && !ArrayUtils.isEmpty((Object[])ajc$this.securitySettingService.getRegistrationGroupIds()) && ajc$this.allowToAddToDefaultGroups(user)) {
                    LOG.info("First time login for user {}, adding it into default groups", new Object[]{username});
                    ajc$this.addUserToDefaultGroups(user);
                    ajc$this.identityRegistry.unregister(username);
                    ajc$this.conversationRegistry.unregisterByUserId(username);
                    Identity identity = ajc$this.authenticator.createIdentity(username);
                    state.getIdentity().setMemberships(identity.getMemberships());
                    state.getIdentity().setRoles(identity.getRoles());
                }
            }
            catch (Exception e) {
                LOG.warn("Error while updating default groups of user {}", new Object[]{username, e});
            }
            finally {
                user.setLastLoginTime(Calendar.getInstance().getTime());
                ajc$this.organizationService.getUserHandler().saveUser(user, true);
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DefaultUserMembershipListener.java", DefaultUserMembershipListener.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onEvent", "io.meeds.portal.security.listener.DefaultUserMembershipListener", "org.exoplatform.services.listener.Event", "event", "java.lang.Exception", "void"), 83);
    }
}

