/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.permlink.plugin;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.plugin.PermanentLinkPlugin;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;

public class ActivityPermanentLinkPlugin
implements PermanentLinkPlugin {
    public static final String OBJECT_TYPE = "activity";
    public static final String URL_FORMAT = "/portal/%s/activity?id=%s";
    private ActivityManager activityManager;
    private UserPortalConfigService portalConfigService;

    public ActivityPermanentLinkPlugin(ActivityManager activityManager, UserPortalConfigService portalConfigService) {
        this.activityManager = activityManager;
        this.portalConfigService = portalConfigService;
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean canAccess(PermanentLinkObject object, Identity identity) throws ObjectNotFoundException {
        if (identity == null || identity.getUserId() == null) {
            return false;
        }
        String activtyId = object.getObjectId();
        ExoSocialActivity activity = this.activityManager.getActivity(activtyId);
        if (activity == null) {
            throw new ObjectNotFoundException(String.format("Activity with id %s not found", object.getObjectId()));
        }
        return this.activityManager.isActivityViewable(activity, identity);
    }

    public String getDirectAccessUrl(PermanentLinkObject object) throws ObjectNotFoundException {
        return String.format(URL_FORMAT, this.portalConfigService.getMetaPortal(), object.getObjectId().replace("comment", ""));
    }
}

