/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.collection.spi.PersistentSet;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.collection.internal.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class SetInitializer
extends AbstractImmediateCollectionInitializer {
    private static final String CONCRETE_NAME = SetInitializer.class.getSimpleName();
    private final DomainResultAssembler<?> elementAssembler;

    public SetInitializer(NavigablePath navigablePath, PluralAttributeMapping setDescriptor, FetchParentAccess parentAccess, LockMode lockMode, DomainResult<?> collectionKeyResult, DomainResult<?> collectionValueKeyResult, Fetch elementFetch, boolean isResultInitializer, AssemblerCreationState creationState) {
        super(navigablePath, setDescriptor, parentAccess, lockMode, collectionKeyResult, collectionValueKeyResult, isResultInitializer, creationState);
        this.elementAssembler = elementFetch.createAssembler(this, creationState);
    }

    @Override
    protected String getSimpleConcreteImplName() {
        return CONCRETE_NAME;
    }

    @Override
    protected void forEachAssembler(Consumer<DomainResultAssembler<?>> consumer) {
        consumer.accept(this.elementAssembler);
    }

    public @Nullable PersistentSet<?> getCollectionInstance() {
        return (PersistentSet)super.getCollectionInstance();
    }

    @Override
    protected void readCollectionRow(CollectionKey collectionKey, List<Object> loadingState, RowProcessingState rowProcessingState) {
        Object element = this.elementAssembler.assemble(rowProcessingState);
        if (element == null) {
            return;
        }
        loadingState.add(element);
    }

    @Override
    protected void initializeSubInstancesFromParent(RowProcessingState rowProcessingState) {
        Initializer initializer = this.elementAssembler.getInitializer();
        if (initializer != null) {
            PersistentCollection set = this.getCollectionInstance();
            assert (set != null);
            Iterator iterator = ((PersistentSet)set).iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                initializer.initializeInstanceFromParent(element, rowProcessingState);
            }
        }
    }

    public String toString() {
        return "SetInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

