/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.util.tracker.ServiceTracker;

public class ServiceFinder {
    private static final Log LOG = LogFactory.getLog(ServiceFinder.class);

    public static <T> Set<T> load(Class<T> contract, ClassLoader ... loaders) {
        LinkedHashSet services = new LinkedHashSet();
        if (loaders.length == 0) {
            try {
                ServiceLoader<T> loadedServices = ServiceLoader.load(contract);
                ServiceFinder.addServices(loadedServices, services);
            }
            catch (Exception exception) {}
        } else {
            for (ClassLoader loader : loaders) {
                if (loader == null) continue;
                try {
                    ServiceLoader<T> loadedServices = ServiceLoader.load(contract, loader);
                    ServiceFinder.addServices(loadedServices, services);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ServiceFinder.addOsgiServices(contract, services);
        if (services.isEmpty()) {
            LOG.debugf("No service impls found: %s", contract.getSimpleName());
        }
        return services;
    }

    private static <T> void addServices(ServiceLoader<T> loadedServices, Set<T> services) {
        Iterator<T> i = loadedServices.iterator();
        while (i.hasNext()) {
            try {
                T service = i.next();
                LOG.debugf("Loading service impl: %s", service.getClass().getSimpleName());
                services.add(service);
            }
            catch (ServiceConfigurationError e) {
                LOG.debugf("Skipping service impl", e);
            }
        }
    }

    private static <T> void addOsgiServices(Class<T> contract, Set<T> services) {
        if (!Util.isOSGiContext()) {
            return;
        }
        ClassLoader loader = ServiceFinder.class.getClassLoader();
        if (loader != null && loader instanceof BundleReference) {
            BundleContext bundleContext = ((BundleReference)loader).getBundle().getBundleContext();
            ServiceTracker serviceTracker = new ServiceTracker(bundleContext, contract.getName(), null);
            serviceTracker.open();
            try {
                Object[] osgiServices = serviceTracker.getServices();
                if (osgiServices != null) {
                    for (Object osgiService : osgiServices) {
                        services.add(osgiService);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

