/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.util;

import java.util.ArrayList;
import java.util.Set;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.SiteBody;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.webui.application.PortletState;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.container.UIComponentFactory;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.page.UISiteBody;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.core.UIComponent;
import org.gatein.common.net.media.MediaType;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.portlet.impl.info.ContainerPortletInfo;

public class PortalDataMapper {
    protected static final Log log = ExoLogger.getLogger((String)"portal:PortalDataMapper");

    private static <S> void toUIPortlet(UIPortlet<S, ?> uiPortlet, Application<S> model) {
        Portlet portlet;
        PortletState portletState = new PortletState(model.getState(), model.getType());
        uiPortlet.setWidth(model.getWidth());
        uiPortlet.setHeight(model.getHeight());
        uiPortlet.setState(portletState);
        uiPortlet.setTitle(model.getTitle());
        uiPortlet.setIcon(model.getIcon());
        uiPortlet.setDescription(model.getDescription());
        uiPortlet.setShowInfoBar(model.getShowInfoBar());
        uiPortlet.setShowWindowState(model.getShowApplicationState());
        uiPortlet.setShowPortletMode(model.getShowApplicationMode());
        uiPortlet.setProperties(model.getProperties());
        uiPortlet.setTheme(model.getTheme());
        uiPortlet.setId(model.getId());
        if (model.getAccessPermissions() != null) {
            uiPortlet.setAccessPermissions(model.getAccessPermissions());
        }
        if ((portlet = uiPortlet.getProducedOfferedPortlet()) == null || portlet.getInfo() == null) {
            return;
        }
        PortletInfo portletInfo = portlet.getInfo();
        Set modes = portletInfo.getCapabilities().getModes(MediaType.create((String)"text/html"));
        uiPortlet.setSupportModes(modes.stream().map(modeInfo -> modeInfo.getModeName().toLowerCase()).filter(mode -> modes.size() == 1 || !"view".equals(mode)).toList());
        if (portletInfo instanceof ContainerPortletInfo) {
            ContainerPortletInfo containerPortletInfo = (ContainerPortletInfo)portletInfo;
            uiPortlet.setCssClass(containerPortletInfo.getInitParameter("layout-css-class"));
        }
    }

    public static void toUIContainer(UIContainer uiContainer, Container model) throws Exception {
        ArrayList children;
        uiContainer.setStorageId(model.getStorageId());
        uiContainer.setId(model.getId());
        uiContainer.setWidth(model.getWidth());
        uiContainer.setHeight(model.getHeight());
        uiContainer.setProfiles(model.getProfiles());
        uiContainer.setCssClass(model.getCssClass());
        uiContainer.setTitle(model.getTitle());
        uiContainer.setIcon(model.getIcon());
        uiContainer.setDescription(model.getDescription());
        uiContainer.setFactoryId(model.getFactoryId());
        uiContainer.setName(model.getName());
        uiContainer.setTemplate(model.getTemplate());
        if (model.getAccessPermissions() != null) {
            uiContainer.setAccessPermissions(model.getAccessPermissions());
        }
        if ((children = model.getChildren()) == null) {
            return;
        }
        for (Object child : children) {
            PortalDataMapper.buildUIContainer(uiContainer, child);
        }
    }

    public static void toUIPage(UIPage uiPage, Page model) throws Exception {
        PortalDataMapper.toUIContainer(uiPage, (Container)model);
        uiPage.setSiteKey(new SiteKey(model.getOwnerType(), model.getOwnerId()));
        uiPage.setIcon(model.getIcon());
        uiPage.setAccessPermissions(model.getAccessPermissions());
        uiPage.setEditPermission(model.getEditPermission());
        uiPage.setFactoryId(model.getFactoryId());
        uiPage.setPageId(model.getPageId());
        uiPage.setTitle(model.getTitle());
        uiPage.setProfiles(model.getProfiles());
        uiPage.setShowMaxWindow(model.isShowMaxWindow());
        uiPage.setHideSharedLayout(model.isHideSharedLayout());
        ArrayList portlets = new ArrayList();
        uiPage.findComponentOfType(portlets, UIPortlet.class);
    }

    public static void toUIPortal(UIPortal uiPortal, PortalConfig model) throws Exception {
        PortalDataMapper.buildUIPortal(uiPortal, model, false);
    }

    public static void toUIPortalWithMetaLayout(UIPortal uiPortal, PortalConfig model) throws Exception {
        PortalDataMapper.buildUIPortal(uiPortal, model, true);
    }

    private static void buildUIPortal(UIPortal uiPortal, PortalConfig model, boolean metaLayout) throws Exception {
        uiPortal.setSiteKey(new SiteKey(model.getType(), model.getName()));
        uiPortal.setStorageId(model.getStorageId());
        uiPortal.setName(model.getName());
        uiPortal.setId("UIPortal");
        uiPortal.setLabel(model.getLabel());
        uiPortal.setDescription(model.getDescription());
        uiPortal.setLocale(model.getLocale());
        uiPortal.setSkin(model.getSkin());
        uiPortal.setAccessPermissions(model.getAccessPermissions());
        uiPortal.setEditPermission(model.getEditPermission());
        uiPortal.setProperties(model.getProperties());
        uiPortal.setUseDynamicLayout(model.isDefaultLayout());
        UserPortalConfigService userPortalConfigService = uiPortal.getApplicationComponent(UserPortalConfigService.class);
        PortalConfig metaSite = userPortalConfigService.getMetaPortalConfig();
        Container layout = metaLayout && model.isDisplayed() ? metaSite.getPortalLayout() : model.getPortalLayout();
        ArrayList children = layout.getChildren();
        if (children != null) {
            for (Object child : children) {
                PortalDataMapper.buildUIContainer(uiPortal, child);
            }
        }
    }

    private static void buildUIContainer(UIContainer uiContainer, Object model) throws Exception {
        UIComponent uiComponent = null;
        PortalRequestContext context = Util.getPortalRequestContext();
        if (model instanceof SiteBody) {
            SiteBody siteBody = (SiteBody)model;
            UISiteBody uiSiteBody = uiContainer.createUIComponent(context, UISiteBody.class, null, null);
            uiSiteBody.setStorageId(siteBody.getStorageId());
            uiComponent = uiSiteBody;
        } else if (model instanceof PageBody) {
            PageBody pageBody = (PageBody)model;
            UIPageBody uiPageBody = uiContainer.createUIComponent(context, UIPageBody.class, null, null);
            uiPageBody.setStorageId(pageBody.getStorageId());
            uiComponent = uiPageBody;
        } else if (model instanceof Application) {
            Application application = (Application)model;
            UIPortlet uiPortlet = uiContainer.createUIComponent(context, UIPortlet.class, null, null);
            uiPortlet.setStorageId(application.getStorageId());
            if (application.getStorageName() != null) {
                uiPortlet.setStorageName(application.getStorageName());
            } else {
                uiPortlet.setStorageName(application.getStorageId());
            }
            PortalDataMapper.toUIPortlet(uiPortlet, application);
            uiComponent = uiPortlet;
        } else if (model instanceof Container) {
            Container container = (Container)model;
            UIComponentFactory<UIContainer> factory = UIComponentFactory.getInstance(UIContainer.class);
            UIContainer uiTempContainer = factory.createUIComponent(container.getFactoryId(), context);
            if (uiTempContainer == null) {
                log.warn("Can't find container factory for: {}. Default container is used", new Object[]{container.getFactoryId()});
                uiTempContainer = uiContainer.createUIComponent(context, UIContainer.class, null, null);
            }
            PortalDataMapper.toUIContainer(uiTempContainer, (Container)model);
            uiComponent = uiTempContainer;
        }
        uiContainer.addChild(uiComponent);
    }
}

