/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.impl;

import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.ObjectAlreadyExistsException;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.notification.model.SpaceWebNotificationItem;
import org.exoplatform.social.notification.plugin.SpaceWebNotificationPlugin;
import org.exoplatform.social.notification.service.SpaceWebNotificationService;
import org.picocontainer.Startable;

public class SpaceWebNotificationServiceImpl
implements SpaceWebNotificationService,
Startable {
    private static final String SPACE_NOT_FOUND = "Space with id %s doesn't exist";
    private static final String USER_NOT_MEMBER_OF_SPACE = "User %s isn't member of space %s";
    public static final String APPLICATION_SUB_ITEM_IDS = "applicationSubItemIds";
    public static final String METADATA_TYPE_NAME = "unread";
    public static final String METADATA_ACTIVITY_ID_PROPERTY = "activityId";
    public static final String METADATA_ACTIVITY_ACTION_TYPE_PROPERTY = "actionType";
    private static final Log LOG = ExoLogger.getLogger(SpaceWebNotificationServiceImpl.class);
    private PortalContainer container;
    private MetadataService metadataService;
    private ListenerService listenerService;
    private PluginSettingService pluginSettingService;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private List<SpaceWebNotificationPlugin> plugins = new ArrayList<SpaceWebNotificationPlugin>();

    public SpaceWebNotificationServiceImpl(PortalContainer container, MetadataService metadataService, PluginSettingService pluginSettingService, ListenerService listenerService, IdentityManager identityManager, SpaceService spaceService) {
        this.container = container;
        this.metadataService = metadataService;
        this.listenerService = listenerService;
        this.pluginSettingService = pluginSettingService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
    }

    public void start() {
        PortalContainer.addInitTask((ServletContext)this.container.getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                for (SpaceWebNotificationPlugin spaceWebNotificationPlugin : SpaceWebNotificationServiceImpl.this.plugins) {
                    List notificationPluginIds = spaceWebNotificationPlugin.getNotificationPluginIds();
                    if (!CollectionUtils.isNotEmpty((Collection)notificationPluginIds)) continue;
                    for (String notificationPluginId : notificationPluginIds) {
                        PluginConfig pluginConfig = SpaceWebNotificationServiceImpl.this.pluginSettingService.getPluginConfig(notificationPluginId);
                        if (pluginConfig == null) {
                            LOG.warn("Notification plugin {} wasn't found", new Object[]{notificationPluginId});
                            continue;
                        }
                        pluginConfig.addAdditionalChannel("SPACE_WEB_CHANNEL");
                    }
                }
            }
        });
    }

    public void stop() {
    }

    public void addPlugin(SpaceWebNotificationPlugin spaceWebNotification) {
        this.plugins.add(0, spaceWebNotification);
    }

    public void dispatch(NotificationInfo notification, String username) throws Exception {
        SpaceWebNotificationItem notificationItem = this.getSpaceWebNotificationItem(notification, username);
        if (notificationItem != null) {
            this.markAsUnread(notificationItem);
        }
    }

    public void markAsUnread(SpaceWebNotificationItem notificationItem) throws Exception {
        if (notificationItem == null) {
            throw new IllegalArgumentException("SpaceWebNotificationItem is mandatory");
        }
        if (notificationItem.getSpaceId() <= 0L) {
            throw new IllegalArgumentException("SpaceWebNotificationItem.spaceId is mandatory");
        }
        if (notificationItem.getUserId() <= 0L) {
            throw new IllegalArgumentException("SpaceWebNotificationItem.userId is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)notificationItem.getApplicationName())) {
            throw new IllegalArgumentException("SpaceWebNotificationItem.applicationName is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)notificationItem.getApplicationItemId())) {
            throw new IllegalArgumentException("SpaceWebNotificationItem.applicationItemId is mandatory");
        }
        long userIdentityId = notificationItem.getUserId();
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE_NAME, String.valueOf(userIdentityId), userIdentityId);
        MetadataObject metadataObject = new MetadataObject(notificationItem.getApplicationName(), notificationItem.getApplicationItemId(), null, notificationItem.getSpaceId());
        try {
            this.mergeExistingUnreadProperties(notificationItem, metadataKey, metadataObject);
            this.metadataService.createMetadataItem(metadataObject, metadataKey, this.toMetadataProperties(notificationItem), userIdentityId);
            this.listenerService.broadcast("notification.unread.item", (Object)notificationItem, (Object)userIdentityId);
        }
        catch (ObjectAlreadyExistsException e) {
            LOG.debug("Object {} already marked as unread", new Object[]{notificationItem});
        }
    }

    public void markAsRead(SpaceWebNotificationItem notificationItem) throws Exception {
        MetadataObject metadataObject;
        if (notificationItem == null) {
            throw new IllegalArgumentException("SpaceWebNotificationItem is mandatory");
        }
        if (notificationItem.getSpaceId() <= 0L) {
            throw new IllegalArgumentException("SpaceWebNotificationItem.spaceId is mandatory");
        }
        if (notificationItem.getUserId() <= 0L) {
            throw new IllegalArgumentException("SpaceWebNotificationItem.userId is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)notificationItem.getApplicationName())) {
            throw new IllegalArgumentException("SpaceWebNotificationItem.applicationName is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)notificationItem.getApplicationItemId())) {
            throw new IllegalArgumentException("SpaceWebNotificationItem.applicationItemId is mandatory");
        }
        long userIdentityId = notificationItem.getUserId();
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE_NAME, String.valueOf(userIdentityId), userIdentityId);
        List metadataItems = this.metadataService.getMetadataItemsByMetadataAndObject(metadataKey, metadataObject = new MetadataObject(notificationItem.getApplicationName(), notificationItem.getApplicationItemId(), null, notificationItem.getSpaceId()));
        if (CollectionUtils.isNotEmpty((Collection)metadataItems)) {
            for (MetadataItem metadataItem : metadataItems) {
                this.metadataService.deleteMetadataItem(metadataItem.getId(), true);
            }
            this.listenerService.broadcast("notification.read.item", (Object)notificationItem, (Object)userIdentityId);
        }
    }

    public void markAllAsRead(long userIdentityId) throws Exception {
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("userIdentityId is mandatory");
        }
        this.metadataService.deleteByMetadataTypeAndCreatorId(METADATA_TYPE_NAME, userIdentityId);
        this.listenerService.broadcast("notification.read.allItems", (Object)new SpaceWebNotificationItem(null, null, userIdentityId, 0L), (Object)userIdentityId);
    }

    public void markAllAsRead(long userIdentityId, long spaceId) throws Exception {
        if (spaceId <= 0L) {
            throw new IllegalArgumentException("spaceId is mandatory");
        }
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("userIdentityId is mandatory");
        }
        this.metadataService.deleteByMetadataTypeAndSpaceIdAndCreatorId(METADATA_TYPE_NAME, spaceId, userIdentityId);
        this.listenerService.broadcast("notification.read.allItems", (Object)new SpaceWebNotificationItem(null, null, userIdentityId, spaceId), (Object)userIdentityId);
    }

    public Map<String, Long> countUnreadItemsByApplication(long userIdentityId, long spaceId) {
        return this.metadataService.countMetadataItemsByMetadataTypeAndAudienceId(METADATA_TYPE_NAME, userIdentityId, spaceId);
    }

    public List<Long> getUnreadActivityIds(String username, long offset, long limit) {
        Identity userIdentity = this.getUserIdentity(username);
        List spaceIds = this.spaceService.getMemberSpacesIds(username, 0, -1);
        if (CollectionUtils.isEmpty((Collection)spaceIds)) {
            return Collections.emptyList();
        }
        return this.getUnreadActivityIds(offset, limit, spaceIds, userIdentity);
    }

    public List<Long> getUnreadActivityIdsBySpace(String username, long spaceId, long offset, long limit) throws IllegalAccessException, ObjectNotFoundException {
        Identity userIdentity = this.getUserIdentity(username);
        String spaceIdString = String.valueOf(spaceId);
        Space space = this.spaceService.getSpaceById(spaceIdString);
        if (space == null) {
            throw new ObjectNotFoundException(String.format(SPACE_NOT_FOUND, spaceId));
        }
        if (!this.spaceService.canViewSpace(space, username)) {
            throw new IllegalAccessException(String.format(USER_NOT_MEMBER_OF_SPACE, username, spaceId));
        }
        return this.getUnreadActivityIds(offset, limit, Collections.singletonList(spaceIdString), userIdentity);
    }

    public Map<Long, Long> countUnreadItemsBySpace(String username) {
        List<Object> spaceIds = new ArrayList();
        Identity userIdentity = this.getUserIdentity(username);
        List spacesId = this.spaceService.getMemberSpacesIds(username, 0, -1);
        if (CollectionUtils.isNotEmpty((Collection)spacesId)) {
            spaceIds = spacesId.stream().map(Long::parseLong).toList();
        }
        return this.metadataService.countMetadataItemsByMetadataTypeAndSpacesIdAndCreatorId(METADATA_TYPE_NAME, Long.parseLong(userIdentity.getId()), spaceIds);
    }

    public long countUnreadActivities(String username) {
        Identity userIdentity = this.getUserIdentity(username);
        List spaceIds = this.spaceService.getMemberSpacesIds(username, 0, -1);
        if (CollectionUtils.isEmpty((Collection)spaceIds)) {
            return 0L;
        }
        return this.countUnreadActivityIds(spaceIds, userIdentity);
    }

    public long countUnreadActivitiesBySpace(String username, long spaceId) throws IllegalAccessException, ObjectNotFoundException {
        Identity userIdentity = this.getUserIdentity(username);
        String spaceIdString = String.valueOf(spaceId);
        Space space = this.spaceService.getSpaceById(spaceIdString);
        if (space == null) {
            throw new ObjectNotFoundException(String.format(SPACE_NOT_FOUND, spaceId));
        }
        if (!this.spaceService.canViewSpace(space, username)) {
            throw new IllegalAccessException(String.format(USER_NOT_MEMBER_OF_SPACE, username, spaceId));
        }
        return this.countUnreadActivityIds(Collections.singletonList(spaceIdString), userIdentity);
    }

    private void mergeExistingUnreadProperties(SpaceWebNotificationItem notificationItem, MetadataKey metadataKey, MetadataObject metadataObject) throws ObjectNotFoundException {
        List metadataItems = this.metadataService.getMetadataItemsByMetadataAndObject(metadataKey, metadataObject);
        if (CollectionUtils.isNotEmpty((Collection)metadataItems)) {
            for (MetadataItem metadataItem : metadataItems) {
                this.appendNotificationSubItems(notificationItem, metadataItem);
                this.metadataService.deleteMetadataItem(metadataItem.getId(), false);
            }
        }
    }

    private void appendNotificationSubItems(SpaceWebNotificationItem notificationItem, MetadataItem metadataItem) {
        String concatenatedSubItemIds;
        if (MapUtils.isNotEmpty((Map)metadataItem.getProperties()) && StringUtils.isNotBlank((CharSequence)(concatenatedSubItemIds = (String)metadataItem.getProperties().get(APPLICATION_SUB_ITEM_IDS)))) {
            Arrays.stream(StringUtils.split((String)concatenatedSubItemIds, (String)",")).forEach(arg_0 -> ((SpaceWebNotificationItem)notificationItem).addApplicationSubItem(arg_0));
        }
    }

    private Map<String, String> toMetadataProperties(SpaceWebNotificationItem notificationItem) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(APPLICATION_SUB_ITEM_IDS, StringUtils.join((Iterable)notificationItem.getApplicationSubItemIds(), (String)","));
        props.put(METADATA_ACTIVITY_ID_PROPERTY, notificationItem.getActivityId());
        props.put(METADATA_ACTIVITY_ACTION_TYPE_PROPERTY, notificationItem.getActivityActionType());
        return props;
    }

    private SpaceWebNotificationItem getSpaceWebNotificationItem(NotificationInfo notification, String username) {
        SpaceWebNotificationItem spaceApplicationItem;
        SpaceWebNotificationPlugin spaceWebNotification = this.plugins.stream().filter(plugin -> plugin.isManagedPlugin(notification.getKey())).findFirst().orElse(null);
        if (spaceWebNotification != null && (spaceApplicationItem = spaceWebNotification.getSpaceApplicationItem(notification, username)) != null && spaceApplicationItem.getSpaceId() > 0L && spaceApplicationItem.getUserId() > 0L && StringUtils.isNotBlank((CharSequence)spaceApplicationItem.getApplicationItemId()) && StringUtils.isNotBlank((CharSequence)spaceApplicationItem.getApplicationName())) {
            return spaceApplicationItem;
        }
        return null;
    }

    private List<Long> getUnreadActivityIds(long offset, long limit, List<String> spaceIds, Identity userIdentity) {
        List unreadItems = this.metadataService.getMetadataItemsByMetadataNameAndTypeAndSpaceIds(userIdentity.getId(), METADATA_TYPE_NAME, spaceIds.stream().map(Long::parseLong).toList(), offset, limit);
        if (CollectionUtils.isEmpty((Collection)unreadItems)) {
            return Collections.emptyList();
        }
        return unreadItems.stream().map(MetadataItem::getProperties).filter(Objects::nonNull).map(prop -> (String)prop.get(METADATA_ACTIVITY_ID_PROPERTY)).filter(Objects::nonNull).map(Long::parseLong).toList();
    }

    private long countUnreadActivityIds(List<String> spaceIds, Identity userIdentity) {
        return this.metadataService.countMetadataItemsByMetadataTypeAndSpacesIdAndCreatorId(METADATA_TYPE_NAME, Long.parseLong(userIdentity.getId()), spaceIds.stream().map(Long::parseLong).toList()).values().stream().reduce(0L, Long::sum);
    }

    private Identity getUserIdentity(String username) {
        Identity userIdentity = this.identityManager.getOrCreateUserIdentity(username);
        if (userIdentity == null) {
            throw new IllegalArgumentException("User " + username + " doesn't exist");
        }
        return userIdentity;
    }
}

