/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgroups.Address;
import org.jgroups.util.Rsp;

public class RspList<T>
implements Map<Address, Rsp<T>>,
Iterable<Rsp<T>> {
    final Map<Address, Rsp<T>> rsps = new HashMap<Address, Rsp<T>>();

    public RspList() {
    }

    public RspList(Collection<Rsp<T>> responses) {
        if (responses != null) {
            for (Rsp<T> rsp : responses) {
                this.rsps.put(rsp.getSender(), rsp);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.rsps.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.rsps.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.rsps.containsValue(value);
    }

    @Override
    public Rsp<T> get(Object key) {
        return this.rsps.get(key);
    }

    public T getValue(Object key) {
        Object rsp = this.get(key);
        return rsp != null ? (T)((Rsp)rsp).getValue() : null;
    }

    @Override
    public Rsp<T> put(Address key, Rsp<T> value) {
        return this.rsps.put(key, value);
    }

    @Override
    public Rsp<T> remove(Object key) {
        return this.rsps.remove(key);
    }

    @Override
    public void putAll(Map<? extends Address, ? extends Rsp<T>> m) {
        this.rsps.putAll(m);
    }

    @Override
    public void clear() {
        this.rsps.clear();
    }

    @Override
    public Set<Address> keySet() {
        return this.rsps.keySet();
    }

    @Override
    public Collection<Rsp<T>> values() {
        return this.rsps.values();
    }

    @Override
    public Set<Map.Entry<Address, Rsp<T>>> entrySet() {
        return this.rsps.entrySet();
    }

    public void addRsp(Address sender, T retval) {
        Object rsp = this.get(sender);
        if (rsp != null) {
            ((Rsp)rsp).setValue(retval);
            return;
        }
        this.rsps.put(sender, new Rsp<T>(sender, retval));
    }

    public void addNotReceived(Address sender) {
        Object rsp = this.get(sender);
        if (rsp == null) {
            this.rsps.put(sender, new Rsp(sender));
        }
    }

    public boolean isReceived(Address sender) {
        Object rsp = this.get(sender);
        return rsp != null && ((Rsp)rsp).wasReceived();
    }

    public int numSuspectedMembers() {
        int num = 0;
        Collection<Rsp<T>> values = this.values();
        for (Rsp<T> rsp : values) {
            if (!rsp.wasSuspected()) continue;
            ++num;
        }
        return num;
    }

    public int numReceived() {
        int num = 0;
        Collection<Rsp<T>> values = this.values();
        for (Rsp<T> rsp : values) {
            if (!rsp.wasReceived()) continue;
            ++num;
        }
        return num;
    }

    public T getFirst() {
        Collection<Rsp<T>> values = this.values();
        for (Rsp<T> rsp : values) {
            if (rsp.getValue() == null) continue;
            return rsp.getValue();
        }
        return null;
    }

    public List<T> getResults() {
        ArrayList<T> ret = new ArrayList<T>(this.size());
        for (Rsp<T> rsp : this.values()) {
            T val;
            if (!rsp.wasReceived() || (val = rsp.getValue()) == null) continue;
            ret.add(val);
        }
        return ret;
    }

    public List<Address> getSuspectedMembers() {
        ArrayList<Address> retval = new ArrayList<Address>();
        for (Rsp<T> rsp : this.values()) {
            if (!rsp.wasSuspected()) continue;
            retval.add(rsp.getSender());
        }
        return retval;
    }

    public boolean isSuspected(Address sender) {
        Object rsp = this.get(sender);
        return rsp != null && ((Rsp)rsp).wasSuspected();
    }

    @Override
    public int size() {
        return this.rsps.size();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        for (Rsp<T> rsp : this.values()) {
            ret.append("[" + rsp + "]\n");
        }
        return ret.toString();
    }

    boolean contains(Address sender) {
        return this.containsKey(sender);
    }

    @Override
    public Iterator<Rsp<T>> iterator() {
        return this.rsps.values().iterator();
    }
}

