/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.GenericScope;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeFilter;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.navigation.VisitMode;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNavigationComparator;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeContext;
import org.exoplatform.portal.mop.user.UserNodeFilter;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserNodeListener;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.mop.user.UserPortalException;
import org.exoplatform.portal.mop.user.Utils;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.ResourceBundleManager;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;

public class UserPortalImpl
implements UserPortal {
    private static final String SPACES_SITE_TYPE_PREFIX = "/spaces/";
    private final UserNavigationComparator userNavigationComparator = new UserNavigationComparator();
    final UserPortalConfigService service;
    private ResourceBundleManager resourceBundleManager;
    private final PortalConfig portalConfig;
    private final String userName;
    private List<UserNavigation> navigations;
    private boolean refreshList;
    private final String portalName;
    private final Locale userLocale;

    public UserPortalImpl(UserPortalConfigService service, String portalName, PortalConfig portal, String userName, Locale locale) {
        this.service = service;
        this.portalName = portalName;
        this.portalConfig = portal;
        this.userName = userName;
        this.navigations = null;
        this.userNavigationComparator.setGlobalPortal(service.getGlobalPortal());
        this.userLocale = locale;
    }

    @Override
    public Locale getLocale() {
        return this.userLocale;
    }

    @Override
    public List<UserNavigation> getNavigations() {
        if (this.navigations == null || this.refreshList) {
            this.loadUserNavigation(new SiteKey(SiteType.PORTAL, this.portalName));
            if (StringUtils.isNotBlank((CharSequence)this.userName)) {
                List<String> userGroupIds = this.getUserGroupIds(ConversationState.getCurrent());
                if (CollectionUtils.isNotEmpty(userGroupIds)) {
                    userGroupIds.forEach(groupId -> this.loadUserNavigation(SiteKey.group((String)groupId)));
                }
                if (this.refreshList) {
                    this.navigations.removeIf(nav -> {
                        SiteKey navSiteKey = nav.getKey();
                        return navSiteKey.getType() == SiteType.GROUP && !userGroupIds.contains(navSiteKey.getName());
                    });
                }
            }
            this.refreshList = false;
        }
        return Collections.unmodifiableList(this.navigations);
    }

    @Override
    public Collection<UserNode> getNodes(SiteType siteType, Scope scope, UserNodeFilterConfig filterConfig) {
        return this.getNodes(siteType, scope, filterConfig, true);
    }

    @Override
    public Collection<UserNode> getNodes(SiteType siteType, Scope scope, UserNodeFilterConfig filterConfig, boolean includeGlobal) {
        ArrayList<UserNode> resultUserNodes = new ArrayList<UserNode>();
        HashSet<String> addedUserNodesURI = new HashSet<String>();
        for (UserNavigation userNavigation : this.getNavigations()) {
            SiteKey siteKey = userNavigation.getKey();
            if (siteKey.getType() != siteType || siteType == SiteType.GROUP && siteKey.getName().startsWith(SPACES_SITE_TYPE_PREFIX) || siteType == SiteType.SPACE && !siteKey.getName().startsWith(SPACES_SITE_TYPE_PREFIX) || !includeGlobal && siteKey.getName().equalsIgnoreCase(this.service.getGlobalPortal())) continue;
            UserNode rootNode = this.getNode(userNavigation, scope, filterConfig, null);
            Collection<UserNode> userNodes = rootNode.getChildren();
            for (UserNode userNode : userNodes) {
                if (addedUserNodesURI.contains(userNode.getURI())) continue;
                addedUserNodesURI.add(userNode.getURI());
                resultUserNodes.add(userNode);
            }
        }
        return resultUserNodes;
    }

    @Override
    public UserNavigation getNavigation(SiteKey key) {
        if (key == null) {
            throw new IllegalArgumentException("SiteKey is mandatory");
        }
        return this.filterUserNavigation(key);
    }

    @Override
    public void refresh() {
        this.refreshList = true;
    }

    @Override
    public UserNode getNode(UserNavigation userNavigation, Scope scope, UserNodeFilterConfig filterConfig, NodeChangeListener<UserNode> listener) throws NullPointerException, UserPortalException, NavigationServiceException {
        if (userNavigation == null || userNavigation.navigation == null) {
            return null;
        }
        UserNodeContext userNodeContext = new UserNodeContext(userNavigation, filterConfig);
        NodeContext nodeContext = this.service.getNavigationService().loadNode((NodeModel)userNodeContext, userNavigation.navigation, scope, (NodeChangeListener)new UserNodeListener(listener));
        if (nodeContext != null) {
            return ((UserNode)nodeContext.getNode()).filter();
        }
        return null;
    }

    @Override
    public UserNode getNodeById(String userNodeId, SiteKey siteKey, Scope scope, UserNodeFilterConfig filterConfig, NodeChangeListener<UserNode> listener) {
        UserNavigation userNavigation = this.getNavigation(siteKey);
        UserNodeContext userNodeContext = new UserNodeContext(userNavigation, filterConfig);
        NodeContext nodeContext = this.service.getNavigationService().loadNodeById((NodeModel)userNodeContext, userNodeId, scope, (NodeChangeListener)new UserNodeListener(listener));
        if (nodeContext != null) {
            return ((UserNode)nodeContext.getNode()).filter();
        }
        return null;
    }

    @Override
    public void updateNode(UserNode node, Scope scope, NodeChangeListener<UserNode> listener) {
        if (node == null) {
            throw new IllegalArgumentException("UserNode is mandatory");
        }
        this.service.getNavigationService().updateNode(node.context, scope, (NodeChangeListener)new UserNodeListener(listener));
        node.filter();
    }

    @Override
    public void rebaseNode(UserNode node, Scope scope, NodeChangeListener<UserNode> listener) {
        if (node == null) {
            throw new IllegalArgumentException("No null node accepted");
        }
        this.service.getNavigationService().rebaseNode(node.context, scope, (NodeChangeListener)new UserNodeListener(listener));
        node.filter();
    }

    @Override
    public void saveNode(UserNode node, NodeChangeListener<UserNode> listener) throws NullPointerException, UserPortalException, NavigationServiceException {
        if (node == null) {
            throw new IllegalArgumentException("No null node accepted");
        }
        this.service.getNavigationService().saveNode(node.context, (NodeChangeListener)new UserNodeListener(listener));
        this.navigations = null;
        node.filter();
    }

    @Override
    public UserNode getDefaultPath(UserNodeFilterConfig filterConfig) throws UserPortalException, NavigationServiceException {
        for (UserNavigation userNavigation : this.getNavigations()) {
            UserNode node = this.getDefaultPath(userNavigation, filterConfig);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    @Override
    public UserNode getDefaultPath(UserNavigation userNavigation, UserNodeFilterConfig filterConfig) throws UserPortalException, NavigationServiceException {
        NavigationContext navigation = userNavigation.navigation;
        if (navigation.getState() != null) {
            UserNodeContext userNodeContext = new UserNodeContext(userNavigation, null);
            NodeContext nodeContext = this.service.getNavigationService().loadNode((NodeModel)userNodeContext, navigation, Scope.CHILDREN, null);
            if (nodeContext != null) {
                UserNode root = (UserNode)nodeContext.getNode();
                if (filterConfig == null) {
                    filterConfig = UserNodeFilterConfig.builder().build();
                }
                UserNodeFilter filter = new UserNodeFilter(userNavigation.portal, filterConfig);
                for (UserNode node : root.getChildren()) {
                    if (!node.context.accept((NodeFilter)filter)) continue;
                    return node;
                }
            }
        }
        return null;
    }

    @Override
    public UserNode resolvePath(UserNodeFilterConfig filterConfig, String path) {
        if (path == null) {
            throw new IllegalArgumentException("No null path accepted");
        }
        String[] segments = Utils.parsePath(path);
        if (segments == null) {
            return this.getDefaultPath(filterConfig);
        }
        filterConfig = filterConfig == null ? UserNodeFilterConfig.builder().build() : UserNodeFilterConfig.builder(filterConfig).build();
        filterConfig.path = segments;
        MatchingScope best = null;
        for (UserNavigation navigation : this.getNavigations()) {
            MatchingScope scope = new MatchingScope(navigation, filterConfig, segments);
            scope.resolve();
            if (scope.score == segments.length) {
                best = scope;
                break;
            }
            if (best == null) {
                best = scope;
                continue;
            }
            if (scope.score <= best.score) continue;
            best = scope;
        }
        if (best != null && best.score > 0) {
            UserNode ret = best.userNode;
            if (ret != null) {
                ret.owner.filterConfig.path = null;
            }
            return ret;
        }
        return this.getDefaultPath(null);
    }

    @Override
    public UserNode resolvePath(UserNavigation navigation, UserNodeFilterConfig filterConfig, String path) throws NullPointerException, UserPortalException, NavigationServiceException {
        if (navigation == null) {
            throw new IllegalArgumentException("No null navigation accepted");
        }
        if (path == null) {
            throw new IllegalArgumentException("No null path accepted");
        }
        String[] segments = Utils.parsePath(path);
        if (segments == null) {
            return null;
        }
        filterConfig = filterConfig == null ? UserNodeFilterConfig.builder().build() : UserNodeFilterConfig.builder(filterConfig).build();
        filterConfig.path = segments;
        MatchingScope scope = new MatchingScope(navigation, filterConfig, segments);
        scope.resolve();
        UserNode globalUserNode = null;
        if (scope.score > 0) {
            UserNode globalNode;
            UserNode ret = scope.userNode;
            if (ret != null && !StringUtils.equals((CharSequence)scope.userNode.getURI(), (CharSequence)ret.getURI()) && (globalNode = this.getGlobalUserNode(filterConfig, navigation.getKey(), segments)) != null) {
                return globalNode;
            }
            if (ret != null) {
                ret.owner.filterConfig.path = null;
                if (!segments[segments.length - 1].equals(ret.getName()) && (globalUserNode = this.getGlobalUserNode(filterConfig, navigation.getKey(), segments)) != null && segments[segments.length - 1].equals(globalUserNode.getName())) {
                    ret = globalUserNode;
                }
                return ret;
            }
        }
        return globalUserNode == null ? this.getGlobalUserNode(filterConfig, navigation.getKey(), segments) : globalUserNode;
    }

    @Override
    public String getPortalLabel(SiteKey siteKey) {
        return this.getPortalLabel(siteKey, this.userLocale);
    }

    @Override
    public String getPortalLabel(SiteKey siteKey, Locale locale) {
        Group siteGroup;
        String label;
        PortalConfig site = this.service.getDataStorage().getPortalConfig(siteKey);
        String string = label = site == null ? siteKey.getName() : (String)StringUtils.firstNonBlank((CharSequence[])new String[]{site.getLabel(), site.getName(), siteKey.getName()});
        if (siteKey.getType() == SiteType.PORTAL) {
            return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.getLabel(siteKey, label, locale), siteKey.getName()});
        }
        if (siteKey.getType() == SiteType.GROUP && (siteGroup = ((OrganizationService)ExoContainerContext.getService(OrganizationService.class)).getGroupHandler().findGroupById(siteKey.getName())) != null) {
            return siteGroup.getLabel();
        }
        return label;
    }

    @Override
    public String getPortalDescription(SiteKey siteKey) {
        return this.getPortalDescription(siteKey, this.userLocale);
    }

    @Override
    public String getPortalDescription(SiteKey siteKey, Locale locale) {
        Group siteGroup;
        String description;
        PortalConfig site = this.service.getDataStorage().getPortalConfig(siteKey);
        String string = description = site == null ? null : site.getDescription();
        if (siteKey.getType() == SiteType.PORTAL && description != null) {
            return this.getLabel(siteKey, description, locale);
        }
        if (siteKey.getType() == SiteType.GROUP && (siteGroup = ((OrganizationService)ExoContainerContext.getService(OrganizationService.class)).getGroupHandler().findGroupById(siteKey.getName())) != null) {
            return siteGroup.getLabel();
        }
        return description;
    }

    public PortalConfig getPortalConfig() {
        return this.portalConfig;
    }

    protected String getLabel(SiteKey siteKey, String label, Locale locale) {
        if (ExpressionUtil.isResourceBindingExpression((String)label)) {
            return Stream.of(locale, ResourceBundleService.DEFAULT_CROWDIN_LOCALE).map(l -> this.getBundle(siteKey.getTypeName(), siteKey.getName(), locale)).filter(Objects::nonNull).map(b -> ExpressionUtil.getExpressionValue((ResourceBundle)b, (String)label)).filter(StringUtils::isNotBlank).findFirst().orElse(null);
        }
        return label;
    }

    protected UserNavigation filterUserNavigation(SiteKey key) {
        UserNavigation userNavigation;
        UserNavigation userNavigation2 = userNavigation = this.navigations == null ? null : (UserNavigation)this.navigations.stream().filter(nav -> nav.getKey().equals((Object)key)).findFirst().orElse(null);
        if (userNavigation == null) {
            this.refreshList = true;
            return this.loadUserNavigation(key);
        }
        return userNavigation;
    }

    protected UserNavigation loadUserNavigation(SiteKey siteKey) {
        if (this.navigations == null) {
            this.navigations = new ArrayList<UserNavigation>();
            if (siteKey.getType() == SiteType.PORTAL && StringUtils.isNotBlank((CharSequence)this.service.getGlobalPortal()) && !StringUtils.equals((CharSequence)this.service.getGlobalPortal(), (CharSequence)siteKey.getName())) {
                this.loadUserNavigation(new SiteKey(SiteType.PORTAL, this.service.getGlobalPortal()));
            }
        } else {
            this.navigations.removeIf(nav -> nav.getKey().equals((Object)siteKey));
        }
        NavigationContext navigationContext = this.service.getNavigationService().loadNavigation(siteKey);
        PortalConfig sitePortalConfig = this.service.getDataStorage().getPortalConfig(siteKey);
        if (navigationContext != null && navigationContext.getState() != null && this.service.getUserACL().hasAccessPermission(sitePortalConfig, this.getCurrentIdentity())) {
            UserACL userACL = this.service.getUserACL();
            UserNavigation userNavigation = new UserNavigation(this, navigationContext, userACL.hasEditPermission(sitePortalConfig, userACL.getUserIdentity(this.userName)));
            this.navigations.add(userNavigation);
            Collections.sort(this.navigations, this.userNavigationComparator);
            return userNavigation;
        }
        return null;
    }

    protected List<String> getUserGroupIds(ConversationState conversationState) {
        Collection groups = null;
        if (conversationState != null && conversationState.getIdentity() != null && !IdentityConstants.ANONIM.equals(conversationState.getIdentity().getUserId()) && !IdentityConstants.SYSTEM.equals(conversationState.getIdentity().getUserId())) {
            groups = conversationState.getIdentity().getGroups();
        } else {
            try {
                groups = ((OrganizationService)ExoContainerContext.getService(OrganizationService.class)).getGroupHandler().findGroupsOfUser(this.userName);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not retrieve groups", e);
            }
        }
        return this.getUserGroupIds(groups);
    }

    protected List<String> getUserGroupIds(Collection<?> groups) {
        String guestsGroupId = this.service.getUserACL().getGuestsGroup();
        return groups.stream().map(groupObj -> {
            if (groupObj instanceof Group) {
                Group group = (Group)groupObj;
                return group.getId().trim();
            }
            return groupObj.toString().trim();
        }).filter(groupId -> !StringUtils.equals((CharSequence)groupId, (CharSequence)guestsGroupId)).toList();
    }

    protected UserNode getGlobalUserNode(UserNodeFilterConfig filterConfig, SiteKey siteKey, String[] segments) {
        UserNavigation globalNavigation = this.getNavigation(SiteKey.portal((String)this.service.getGlobalPortal()));
        if (globalNavigation != null) {
            MatchingScope globalScope = new MatchingScope(globalNavigation, filterConfig, segments);
            globalScope.resolve();
            if (globalScope.score > 0) {
                UserNode globalNode = globalScope.userNode;
                if (globalNode != null) {
                    globalNode.owner.filterConfig.path = null;
                }
                if (globalNode != null && StringUtils.equals((CharSequence)globalScope.userNode.getURI(), (CharSequence)globalNode.getURI())) {
                    return globalNode;
                }
            }
        }
        return null;
    }

    protected ResourceBundle getNavigationBundle(SiteKey siteKey) {
        UserNavigation navigation = this.getNavigation(siteKey);
        return navigation == null ? null : navigation.getBundle();
    }

    public ResourceBundle getBundle(UserNavigation navigation) {
        return this.getBundle(this.getSiteType(navigation), this.getSiteName(navigation), this.userLocale);
    }

    private ResourceBundle getBundle(String siteType, String siteName, Locale locale) {
        return this.getResourceBundleManager().getNavigationResourceBundle(LocaleContextInfo.getLocaleAsString((Locale)locale), siteType, siteName);
    }

    private String getSiteName(UserNavigation navigation) {
        return navigation.getKey().getName();
    }

    private String getSiteType(UserNavigation navigation) {
        return navigation.getKey().getTypeName();
    }

    private ResourceBundleManager getResourceBundleManager() {
        if (this.resourceBundleManager == null) {
            this.resourceBundleManager = (ResourceBundleManager)ExoContainerContext.getService(ResourceBundleManager.class);
        }
        return this.resourceBundleManager;
    }

    private Identity getCurrentIdentity() {
        ConversationState conversationState = ConversationState.getCurrent();
        return conversationState == null ? null : conversationState.getIdentity();
    }

    @Override
    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public Locale getUserLocale() {
        return this.userLocale;
    }

    protected class MatchingScope
    extends GenericScope.Branch.Visitor
    implements Scope {
        final UserNavigation userNavigation;
        final UserNodeFilterConfig filterConfig;
        final String[] match;
        int score;
        String id;
        UserNode userNode;

        MatchingScope(UserNavigation userNavigation, UserNodeFilterConfig filterConfig, String[] match) {
            this.userNavigation = userNavigation;
            this.filterConfig = filterConfig;
            this.match = match;
        }

        public Scope.Visitor get() {
            return this;
        }

        protected int getSize() {
            return this.match.length;
        }

        protected String getName(int index) {
            return this.match[index];
        }

        protected Scope.Visitor getFederated() {
            return Scope.CHILDREN.get();
        }

        public VisitMode enter(int depth, String id, String name, NodeState state) {
            VisitMode vm = super.enter(depth, id, name, state);
            if (depth == 0) {
                this.score = 0;
                this.id = null;
            } else if (vm == VisitMode.ALL_CHILDREN) {
                this.id = id;
                ++this.score;
            }
            return vm;
        }

        void resolve() {
            UserNodeContext userNodeContext = new UserNodeContext(this.userNavigation, this.filterConfig);
            NodeContext nodeContext = UserPortalImpl.this.service.getNavigationService().loadNode((NodeModel)userNodeContext, this.userNavigation.navigation, (Scope)this, null);
            if (this.score > 0) {
                this.userNode = ((UserNode)nodeContext.getNode()).filter().find(this.id);
            }
        }
    }
}

