/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.spi.NavigablePath;

public class SqmTreatedSetJoin<O, T, S extends T>
extends SqmSetJoin<O, S>
implements SqmTreatedPath<T, S> {
    private final SqmSetJoin<O, T> wrappedPath;
    private final EntityDomainType<S> treatTarget;

    public SqmTreatedSetJoin(SqmSetJoin<O, T> wrappedPath, EntityDomainType<S> treatTarget, String alias) {
        this(wrappedPath, treatTarget, alias, false);
    }

    public SqmTreatedSetJoin(SqmSetJoin<O, T> wrappedPath, EntityDomainType<S> treatTarget, String alias, boolean fetched) {
        super(wrappedPath.getLhs(), wrappedPath.getNavigablePath().append(CollectionPart.Nature.ELEMENT.getName()).treatAs(treatTarget.getHibernateEntityName(), alias), wrappedPath.getAttribute(), alias, wrappedPath.getSqmJoinType(), fetched, (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    private SqmTreatedSetJoin(NavigablePath navigablePath, SqmSetJoin<O, T> wrappedPath, EntityDomainType<S> treatTarget, String alias, boolean fetched) {
        super(wrappedPath.getLhs(), navigablePath, wrappedPath.getAttribute(), alias, wrappedPath.getSqmJoinType(), fetched, (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    @Override
    public SqmTreatedSetJoin<O, T, S> copy(SqmCopyContext context) {
        SqmTreatedSetJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTreatedSetJoin<O, T, S> path = context.registerCopy(this, new SqmTreatedSetJoin<O, T, S>(this.getNavigablePath(), this.wrappedPath.copy(context), this.treatTarget, this.getExplicitAlias(), this.isFetched()));
        this.copyTo(path, context);
        return path;
    }

    public SqmSetJoin<O, T> getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public EntityDomainType<S> getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<S> getNodeType() {
        return this.treatTarget;
    }

    @Override
    public EntityDomainType<S> getReferencedPathSource() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<?> getResolvedModel() {
        return this.treatTarget;
    }

    @Override
    public SqmAttributeJoin<O, S> makeCopy(SqmCreationProcessingState creationProcessingState) {
        return new SqmTreatedSetJoin<O, T, S>(this.wrappedPath, this.treatTarget, this.getAlias());
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("treat(");
        this.wrappedPath.appendHqlString(sb);
        sb.append(" as ");
        sb.append(this.treatTarget.getName());
        sb.append(')');
    }
}

