/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.OwnedValuedModelPart;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.AbstractTableGroup;
import org.hibernate.sql.ast.tree.from.CorrelatedTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.VirtualTableGroup;

public class StandardVirtualTableGroup
extends AbstractTableGroup
implements VirtualTableGroup {
    private final TableGroup underlyingTableGroup;
    private final boolean fetched;

    public StandardVirtualTableGroup(NavigablePath navigablePath, ModelPartContainer modelPart, TableGroup underlyingTableGroup, boolean fetched) {
        super(underlyingTableGroup.canUseInnerJoins(), navigablePath, modelPart, NullnessUtil.castNonNull(navigablePath.getRealParent()).getAlias(), null, null);
        this.underlyingTableGroup = underlyingTableGroup;
        this.fetched = fetched;
    }

    @Override
    public ModelPartContainer getExpressionType() {
        return this.getModelPart();
    }

    @Override
    public TableGroup getUnderlyingTableGroup() {
        return this.underlyingTableGroup;
    }

    @Override
    public boolean isFetched() {
        return this.fetched;
    }

    @Override
    public String getSourceAlias() {
        return this.underlyingTableGroup.getSourceAlias();
    }

    @Override
    public boolean canUseInnerJoins() {
        return this.underlyingTableGroup.canUseInnerJoins();
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        this.underlyingTableGroup.applyAffectedTableNames(nameCollector);
    }

    @Override
    public TableReference getPrimaryTableReference() {
        return this.underlyingTableGroup.getPrimaryTableReference();
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return this.underlyingTableGroup.getTableReferenceJoins();
    }

    @Override
    public void addTableGroupJoin(TableGroupJoin join) {
        super.addTableGroupJoin(join);
        this.registerPredicateOnCorrelatedTableGroup(join);
    }

    @Override
    public void prependTableGroupJoin(NavigablePath navigablePath, TableGroupJoin join) {
        super.prependTableGroupJoin(navigablePath, join);
        this.registerPredicateOnCorrelatedTableGroup(join);
    }

    @Override
    public void addNestedTableGroupJoin(TableGroupJoin join) {
        super.addNestedTableGroupJoin(join);
        this.registerPredicateOnCorrelatedTableGroup(join);
    }

    private void registerPredicateOnCorrelatedTableGroup(TableGroupJoin join) {
        TableGroup tableGroup = this.underlyingTableGroup;
        while (tableGroup instanceof StandardVirtualTableGroup) {
            tableGroup = ((StandardVirtualTableGroup)tableGroup).underlyingTableGroup;
        }
        if (tableGroup instanceof CorrelatedTableGroup) {
            ((CorrelatedTableGroup)tableGroup).getJoinPredicateConsumer().accept(join.getPredicate());
        }
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean resolve) {
        TableReference tableReference = this.underlyingTableGroup.getTableReference(navigablePath, tableExpression, resolve);
        if (tableReference != null) {
            return tableReference;
        }
        for (TableReferenceJoin tableJoin : this.getTableReferenceJoins()) {
            TableReference joinedTableReference = tableJoin.getJoinedTableReference().getTableReference(navigablePath, tableExpression, resolve);
            if (joinedTableReference == null) continue;
            return joinedTableReference;
        }
        return null;
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, ValuedModelPart modelPart, String tableExpression, boolean resolve) {
        MappingType declaringType;
        ValuedModelPart parentModelPart = modelPart instanceof OwnedValuedModelPart && (declaringType = ((OwnedValuedModelPart)modelPart).getDeclaringType()) instanceof EmbeddableMappingType ? ((EmbeddableMappingType)declaringType).getEmbeddedValueMapping() : modelPart;
        TableReference tableReference = this.underlyingTableGroup.getTableReference(navigablePath, parentModelPart, tableExpression, resolve);
        if (tableReference != null) {
            return tableReference;
        }
        for (TableReferenceJoin tableJoin : this.getTableReferenceJoins()) {
            TableReference joinedTableReference = tableJoin.getJoinedTableReference().getTableReference(navigablePath, modelPart, tableExpression, resolve);
            if (joinedTableReference == null) continue;
            return joinedTableReference;
        }
        return null;
    }
}

