/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.common.persistence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.picocontainer.Startable;

@Managed
@ManagedDescription(value="Hibernate Statistics Service")
@NameTemplate(value={@Property(key="service", value="HibernateStatisticsService")})
@RESTEndpoint(path="hibernateStatisticsService")
public class HibernateStatisticsService
implements Startable,
ComponentRequestLifecycle {
    private static final Log LOG = ExoLogger.getLogger(HibernateStatisticsService.class);
    private ExoContainer container;
    private EntityManagerService entityManagerService;
    private ListenerService listenerService;
    private ThreadLocal<Boolean> collectionStarted = new ThreadLocal();
    private List<String> ignoredQueryMatch = new ArrayList<String>();
    private String[] ignoredQueryMatchArray = new String[0];
    private SessionFactoryImplementor sessionFactory;
    private boolean enabled;
    private boolean logResult;

    public HibernateStatisticsService(ExoContainer container, EntityManagerService entityManagerService, ListenerService listenerService) {
        this.entityManagerService = entityManagerService;
        this.listenerService = listenerService;
        this.container = container;
    }

    public void start() {
        this.enabled = Boolean.parseBoolean(System.getProperty("meeds.hibernate.statistics.enabled", "false"));
        this.logResult = Boolean.parseBoolean(System.getProperty("meeds.hibernate.statistics.logResult", "true"));
        this.ignoredQueryMatch = new ArrayList<String>(Arrays.asList(StringUtils.split((String)System.getProperty("meeds.hibernate.statistics.ignoredQueryMatch", ""), (String)";")));
        this.ignoredQueryMatchArray = (String[])this.ignoredQueryMatch.toArray(String[]::new);
        this.getStatistics().setStatisticsEnabled(this.enabled);
    }

    public void startRequest(ExoContainer container) {
        if (this.enabled) {
            this.collectionStarted.set(true);
        }
    }

    public void endRequest(ExoContainer container) {
        if (this.enabled && this.isStarted(container)) {
            try {
                StatisticsImplementor statistics = this.getStatistics();
                CompletableFuture.runAsync(() -> this.endStatisticsCollection(statistics));
            }
            finally {
                this.collectionStarted.remove();
            }
        }
    }

    public boolean isStarted(ExoContainer container) {
        return this.collectionStarted.get() != null && this.collectionStarted.get() != false;
    }

    @Managed
    @Impact(value=ImpactType.WRITE)
    @ManagedDescription(value="Enable/Disable Hibernate Queries Statistics Collection")
    public void setEnabled(@ManagedName(value="enabled") @ManagedDescription(value="Flag to enable (true) or disable (false) stats") boolean enabled) {
        this.getStatistics().setStatisticsEnabled(enabled);
        this.enabled = enabled;
    }

    @Managed
    @Impact(value=ImpactType.READ)
    @ManagedDescription(value="Return the Hibernate Queries Statistics Collection Enablement Status")
    public boolean isEnabled() {
        return this.enabled;
    }

    @Managed
    @Impact(value=ImpactType.WRITE)
    @ManagedDescription(value="Whether to log results or broadcast performances throw ListenerService for external integrations")
    public void setLogResult(@ManagedDescription(value="logResult") @ManagedName(value="logResult") boolean logResult) {
        this.logResult = logResult;
    }

    @Managed
    @Impact(value=ImpactType.READ)
    @ManagedDescription(value="Return the 'log results' flag value")
    public boolean isLogResult() {
        return this.logResult;
    }

    @Managed
    @Impact(value=ImpactType.WRITE)
    @ManagedDescription(value="Add an Hibernate Query part matched string to ignore in statistics collection")
    public void addIgnoredMatch(@ManagedName(value="queryMatch") @ManagedDescription(value="Query part matched string") String queryMatch) {
        this.ignoredQueryMatch.add(queryMatch);
        this.ignoredQueryMatchArray = (String[])this.ignoredQueryMatch.toArray(String[]::new);
    }

    private void endStatisticsCollection(StatisticsImplementor statistics) {
        Object[] queries = statistics.getQueries();
        if (ArrayUtils.isEmpty((Object[])queries)) {
            return;
        }
        List<String> performances = Arrays.stream(queries).filter(q -> !StringUtils.containsAny((CharSequence)q, (CharSequence[])this.ignoredQueryMatchArray)).map(q -> {
            QueryStatistics stats = statistics.getQueryStatistics(q);
            return String.format("%s;count=%s;dur=%s;max=%s;avg=%s;min=%s", q.replace("\r\n", " ").replace("\n", " ").replace("\r", " "), stats.getExecutionCount(), stats.getExecutionTotalTime(), stats.getExecutionMaxTime(), stats.getExecutionAvgTime(), stats.getExecutionMinTime());
        }).toList();
        if (this.logResult) {
            performances.forEach(arg_0 -> ((Log)LOG).info(arg_0));
        } else {
            this.listenerService.broadcast("meeds.hibernate.statistics", performances, (Object)statistics);
        }
        this.getStatistics().clear();
    }

    private StatisticsImplementor getStatistics() {
        return this.getSessionFactory().getStatistics();
    }

    public SessionFactoryImplementor getSessionFactory() {
        if (this.sessionFactory == null) {
            boolean started = this.entityManagerService.isStarted(this.container);
            if (!started) {
                this.entityManagerService.startRequest(this.container);
            }
            try {
                Session session = (Session)this.entityManagerService.getEntityManager().getDelegate();
                this.sessionFactory = (SessionFactoryImplementor)session.getSessionFactory();
            }
            finally {
                if (!started) {
                    this.entityManagerService.endRequest(this.container);
                }
            }
        }
        return this.sessionFactory;
    }
}

