/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.AnalyticsStatistics;
import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Analytics
extends Base {
    private final AnalyticsStatistics stats;
    public static final JsonpDeserializer<Analytics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Analytics::setupAnalyticsDeserializer);

    private Analytics(Builder builder) {
        super(builder);
        this.stats = ApiTypeHelper.requireNonNull(builder.stats, this, "stats");
    }

    public static Analytics of(Function<Builder, ObjectBuilder<Analytics>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final AnalyticsStatistics stats() {
        return this.stats;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("stats");
        this.stats.serialize(generator, mapper);
    }

    protected static void setupAnalyticsDeserializer(ObjectDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::stats, AnalyticsStatistics._DESERIALIZER, "stats");
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Analytics> {
        private AnalyticsStatistics stats;

        public final Builder stats(AnalyticsStatistics value) {
            this.stats = value;
            return this;
        }

        public final Builder stats(Function<AnalyticsStatistics.Builder, ObjectBuilder<AnalyticsStatistics>> fn) {
            return this.stats(fn.apply(new AnalyticsStatistics.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Analytics build() {
            this._checkSingleUse();
            return new Analytics(this);
        }
    }
}

