/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.session.RedisSessionProperties;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.config.ReactiveSessionRepositoryCustomizer;
import org.springframework.session.data.redis.ReactiveRedisSessionRepository;
import org.springframework.session.data.redis.config.annotation.web.server.RedisWebSessionConfiguration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ReactiveRedisConnectionFactory.class, ReactiveRedisSessionRepository.class})
@ConditionalOnMissingBean(value={ReactiveSessionRepository.class})
@ConditionalOnBean(value={ReactiveRedisConnectionFactory.class})
@EnableConfigurationProperties(value={RedisSessionProperties.class})
@Import(value={RedisWebSessionConfiguration.class})
class RedisReactiveSessionConfiguration {
    RedisReactiveSessionConfiguration() {
    }

    @Bean
    ReactiveSessionRepositoryCustomizer<ReactiveRedisSessionRepository> springBootSessionRepositoryCustomizer(SessionProperties sessionProperties, RedisSessionProperties redisSessionProperties, ServerProperties serverProperties) {
        return sessionRepository -> {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from((Object)sessionProperties.determineTimeout(() -> serverProperties.getReactive().getSession().getTimeout())).to(arg_0 -> ((ReactiveRedisSessionRepository)sessionRepository).setDefaultMaxInactiveInterval(arg_0));
            map.from(redisSessionProperties::getNamespace).to(arg_0 -> ((ReactiveRedisSessionRepository)sessionRepository).setRedisKeyNamespace(arg_0));
            map.from(redisSessionProperties::getSaveMode).to(arg_0 -> ((ReactiveRedisSessionRepository)sessionRepository).setSaveMode(arg_0));
        };
    }
}

