/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.jpa.email;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.storage.MailNotificationStorage;
import org.exoplatform.commons.api.persistence.DataInitializer;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.notification.impl.jpa.email.JPAMailNotificationStorage$AjcClosure1;
import org.exoplatform.commons.notification.impl.jpa.email.JPAMailNotificationStorage$AjcClosure3;
import org.exoplatform.commons.notification.impl.jpa.email.JPAMailNotificationStorage$AjcClosure5;
import org.exoplatform.commons.notification.impl.jpa.email.JPAMailNotificationStorage$AjcClosure7;
import org.exoplatform.commons.notification.impl.jpa.email.dao.MailDigestDAO;
import org.exoplatform.commons.notification.impl.jpa.email.dao.MailNotifDAO;
import org.exoplatform.commons.notification.impl.jpa.email.dao.MailParamDAO;
import org.exoplatform.commons.notification.impl.jpa.email.entity.MailDigestEntity;
import org.exoplatform.commons.notification.impl.jpa.email.entity.MailNotifEntity;
import org.exoplatform.commons.notification.impl.jpa.email.entity.MailParamEntity;
import org.exoplatform.commons.notification.job.NotificationJob;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JPAMailNotificationStorage
implements MailNotificationStorage {
    private static final int QUERY_LIMIT = 100;
    private static final Log LOG;
    public static final String DIGEST_DAILY = "daily";
    public static final String DIGEST_WEEKLY = "weekly";
    public static final ArgumentLiteral<Map> WEEKLY_NOTIFS;
    public static final ArgumentLiteral<Map> DAILY_NOTIFS;
    private MailNotifDAO mailNotifDAO;
    private MailDigestDAO mailDigestDAO;
    private MailParamDAO mailParamDAO;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public JPAMailNotificationStorage(MailNotifDAO mailNotifDAO, MailDigestDAO mailDigestDAO, MailParamDAO mailParamDAO, DataInitializer dataInitializer) {
        this.mailNotifDAO = mailNotifDAO;
        this.mailDigestDAO = mailDigestDAO;
        this.mailParamDAO = mailParamDAO;
    }

    @ExoTransactional
    public void save(NotificationInfo message) throws Exception {
        NotificationInfo notificationInfo = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)notificationInfo);
        Object[] objectArray = new Object[]{this, notificationInfo, joinPoint};
        JPAMailNotificationStorage$AjcClosure1 jPAMailNotificationStorage$AjcClosure1 = new JPAMailNotificationStorage$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(jPAMailNotificationStorage$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public Map<PluginKey, List<NotificationInfo>> getByUser(NotificationContext context, UserSetting setting) {
        NotificationContext notificationContext = context;
        UserSetting userSetting = setting;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)notificationContext, (Object)userSetting);
        Object[] objectArray = new Object[]{this, notificationContext, userSetting, joinPoint};
        JPAMailNotificationStorage$AjcClosure3 jPAMailNotificationStorage$AjcClosure3 = new JPAMailNotificationStorage$AjcClosure3(objectArray);
        return (Map)ExoTransactionalAspect.aspectOf().around(jPAMailNotificationStorage$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void removeMessageAfterSent(NotificationContext context) throws Exception {
        NotificationContext notificationContext = context;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)notificationContext);
        Object[] objectArray = new Object[]{this, notificationContext, joinPoint};
        JPAMailNotificationStorage$AjcClosure5 jPAMailNotificationStorage$AjcClosure5 = new JPAMailNotificationStorage$AjcClosure5(objectArray);
        ExoTransactionalAspect.aspectOf().around(jPAMailNotificationStorage$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void deleteAllDigests() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        JPAMailNotificationStorage$AjcClosure7 jPAMailNotificationStorage$AjcClosure7 = new JPAMailNotificationStorage$AjcClosure7(objectArray);
        ExoTransactionalAspect.aspectOf().around(jPAMailNotificationStorage$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    private List<NotificationInfo> getWeeklyNotifs(NotificationContext context, String pluginId, String userId) {
        return this.getNotificationsByDigestAndPluginId(context, WEEKLY_NOTIFS, pluginId, userId);
    }

    private List<NotificationInfo> getDailyNotifs(NotificationContext context, String pluginId, String userId) {
        return this.getNotificationsByDigestAndPluginId(context, DAILY_NOTIFS, pluginId, userId);
    }

    private List<NotificationInfo> getNotificationsByDigestAndPluginId(NotificationContext context, ArgumentLiteral<Map> notifsDigestArgument, String pluginId, String userId) {
        HashMap<String, List<NotificationInfo>> notificationsByPluginId = (HashMap<String, List<NotificationInfo>>)context.value(notifsDigestArgument);
        if (notificationsByPluginId == null) {
            notificationsByPluginId = new HashMap<String, List<NotificationInfo>>();
            context.append(notifsDigestArgument, notificationsByPluginId);
        }
        List<NotificationInfo> notificationInfos = null;
        if (notificationsByPluginId.containsKey(pluginId)) {
            notificationInfos = (List)notificationsByPluginId.get(pluginId);
        } else {
            notificationInfos = new ArrayList();
            List<MailNotifEntity> notifEntities = notifsDigestArgument == WEEKLY_NOTIFS ? this.getNotifsByWeek(pluginId) : this.getNotifsByDate(context, pluginId);
            for (MailNotifEntity mailNotifEntity : notifEntities) {
                NotificationInfo model = this.fillModel(mailNotifEntity, null);
                notificationInfos.add(model);
            }
            notificationsByPluginId.put(pluginId, notificationInfos);
        }
        ArrayList<NotificationInfo> resultNotificationInfos = new ArrayList<NotificationInfo>();
        for (NotificationInfo notificationInfo : notificationInfos) {
            NotificationInfo resultNotificationInfo = notificationInfo.clone(false);
            resultNotificationInfo.setTo(userId);
            resultNotificationInfos.add(resultNotificationInfo);
        }
        return resultNotificationInfos;
    }

    private void putMap(Map<PluginKey, List<NotificationInfo>> notificationData, PluginKey key, List<NotificationInfo> values) {
        if (notificationData.containsKey(key)) {
            List<NotificationInfo> messages = notificationData.get(key);
            for (NotificationInfo notificationMessage : values) {
                if (messages.size() != 0 && messages.contains(notificationMessage)) continue;
                messages.add(notificationMessage);
            }
            if (messages.size() > 0) {
                notificationData.put(key, messages);
            }
        } else if (values.size() > 0) {
            notificationData.put(key, values);
        }
    }

    private NotificationInfo fillModel(MailNotifEntity notifEntity, String userId) {
        if (notifEntity == null) {
            return null;
        }
        NotificationInfo message = NotificationInfo.instance().setFrom(notifEntity.getSender()).setTo(userId).setOrder(notifEntity.getOrder()).key(notifEntity.getType()).setOwnerParameter(JPAMailNotificationStorage.convertParamsEntityToParams(notifEntity.getParameters())).setLastModifiedDate(notifEntity.getCreationDate()).setId(String.valueOf(notifEntity.getId()));
        return message;
    }

    private static Map<String, String> convertParamsEntityToParams(Collection<MailParamEntity> paramsEntityList) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (MailParamEntity paramsEntity : paramsEntityList) {
            params.put(paramsEntity.getName(), paramsEntity.getValue());
        }
        return params;
    }

    private List<MailNotifEntity> getNotifsByDate(NotificationContext context, String pluginId) {
        String dayName = (String)context.value(NotificationJob.DAY_OF_JOB);
        return this.mailNotifDAO.getNotifsByPluginAndDay(pluginId, dayName);
    }

    private List<MailNotifEntity> getNotifsByWeek(String pluginId) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        Calendar oneWeekAgo = calendar;
        return this.mailNotifDAO.getNotifsByPluginAndWeek(pluginId, oneWeekAgo);
    }

    static {
        JPAMailNotificationStorage.ajc$preClinit();
        LOG = ExoLogger.getLogger(JPAMailNotificationStorage.class);
        WEEKLY_NOTIFS = new ArgumentLiteral(Map.class, "weekly_notifications");
        DAILY_NOTIFS = new ArgumentLiteral(Map.class, "daily_notifications");
    }

    static final /* synthetic */ void save_aroundBody0(JPAMailNotificationStorage ajc$this, NotificationInfo message, JoinPoint joinPoint) {
        MailNotifEntity notifEntity = new MailNotifEntity();
        notifEntity.setSender(message.getFrom());
        notifEntity.setOrder(message.getOrder());
        notifEntity.setType(message.getKey().getId());
        notifEntity.setCreationDate(message.getDateCreated());
        notifEntity = (MailNotifEntity)ajc$this.mailNotifDAO.create(notifEntity);
        message.setId(String.valueOf(notifEntity.getId()));
        MailDigestEntity digestEntityDaily = new MailDigestEntity();
        digestEntityDaily.setNotification(notifEntity).setType(DIGEST_DAILY);
        ajc$this.mailDigestDAO.create(digestEntityDaily);
        MailDigestEntity digestEntityWeekly = new MailDigestEntity();
        digestEntityWeekly.setNotification(notifEntity).setType(DIGEST_WEEKLY);
        ajc$this.mailDigestDAO.create(digestEntityWeekly);
        Map parameters = message.getOwnerParameter();
        if (parameters != null && !parameters.isEmpty()) {
            for (String key : parameters.keySet()) {
                MailParamEntity paramEntity = new MailParamEntity();
                paramEntity.setName(key);
                paramEntity.setValue((String)parameters.get(key));
                paramEntity.setNotification(notifEntity);
                ajc$this.mailParamDAO.create(paramEntity);
            }
        }
    }

    static final /* synthetic */ Map getByUser_aroundBody2(JPAMailNotificationStorage ajc$this, NotificationContext context, UserSetting setting, JoinPoint joinPoint) {
        boolean isDaily;
        LinkedHashMap<PluginKey, List<NotificationInfo>> notificationData = new LinkedHashMap<PluginKey, List<NotificationInfo>>();
        boolean isWeekly = (Boolean)context.value(NotificationJob.JOB_WEEKLY);
        if (isWeekly) {
            for (String pluginId : setting.getWeeklyPlugins()) {
                ajc$this.putMap(notificationData, PluginKey.key((String)pluginId), ajc$this.getWeeklyNotifs(context, pluginId, setting.getUserId()));
            }
        }
        if (isDaily = ((Boolean)context.value(NotificationJob.JOB_DAILY)).booleanValue()) {
            for (String pluginId : setting.getDailyPlugins()) {
                ajc$this.putMap(notificationData, PluginKey.key((String)pluginId), ajc$this.getDailyNotifs(context, pluginId, setting.getUserId()));
            }
        }
        return notificationData;
    }

    static final /* synthetic */ void removeMessageAfterSent_aroundBody4(JPAMailNotificationStorage ajc$this, NotificationContext context, JoinPoint joinPoint) {
        List<MailNotifEntity> allNotificationsWithoutDigests;
        boolean isWeekly = (Boolean)context.value(NotificationJob.JOB_WEEKLY);
        Map generalWeeklyNotificationData = null;
        generalWeeklyNotificationData = isWeekly ? (Map)context.value(WEEKLY_NOTIFS) : (Map)context.value(DAILY_NOTIFS);
        if (generalWeeklyNotificationData == null) {
            ajc$this.mailDigestDAO.deleteAllDigestsOfType(isWeekly ? DIGEST_WEEKLY : DIGEST_DAILY);
        } else {
            HashSet<Long> mailNotifsIds = new HashSet<Long>();
            Collection notificationsLists = generalWeeklyNotificationData.values();
            for (List notificationsList : notificationsLists) {
                if (notificationsList == null) continue;
                for (NotificationInfo notificationInfo : notificationsList) {
                    try {
                        mailNotifsIds.add(Long.parseLong(notificationInfo.getId()));
                    }
                    catch (NumberFormatException e) {
                        LOG.warn((Object)("can't parse mail notification with id: " + notificationInfo.getId()));
                    }
                }
            }
            if (mailNotifsIds != null && !mailNotifsIds.isEmpty()) {
                ajc$this.mailDigestDAO.deleteDigestsOfTypeByNotificationsIds(mailNotifsIds, isWeekly ? DIGEST_WEEKLY : DIGEST_DAILY);
            }
        }
        do {
            if ((allNotificationsWithoutDigests = ajc$this.mailNotifDAO.getAllNotificationsWithoutDigests(0, 100)) == null || allNotificationsWithoutDigests.isEmpty()) continue;
            ajc$this.mailParamDAO.deleteParamsOfNotifications(allNotificationsWithoutDigests);
            ajc$this.mailNotifDAO.deleteAll(allNotificationsWithoutDigests);
        } while (allNotificationsWithoutDigests.size() == 100);
    }

    static final /* synthetic */ void deleteAllDigests_aroundBody6(JPAMailNotificationStorage ajc$this, JoinPoint joinPoint) {
        ajc$this.mailDigestDAO.deleteAllDigests();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JPAMailNotificationStorage.java", JPAMailNotificationStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "save", "org.exoplatform.commons.notification.impl.jpa.email.JPAMailNotificationStorage", "org.exoplatform.commons.api.notification.model.NotificationInfo", "message", "java.lang.Exception", "void"), 68);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getByUser", "org.exoplatform.commons.notification.impl.jpa.email.JPAMailNotificationStorage", "org.exoplatform.commons.api.notification.NotificationContext:org.exoplatform.commons.api.notification.model.UserSetting", "context:setting", "", "java.util.Map"), 103);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeMessageAfterSent", "org.exoplatform.commons.notification.impl.jpa.email.JPAMailNotificationStorage", "org.exoplatform.commons.api.notification.NotificationContext", "context", "java.lang.Exception", "void"), 127);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteAllDigests", "org.exoplatform.commons.notification.impl.jpa.email.JPAMailNotificationStorage", "", "", "java.lang.Exception", "void"), 170);
    }
}

