/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.rest;

import io.meeds.layout.model.CoeditionObjectDraft;
import io.meeds.layout.model.CoeditionObjectKey;
import io.meeds.layout.service.CoeditingService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/coediting"})
@Tag(name="/coediting", description="Managing layout coedition")
public class CoeditingRest {
    @Autowired
    private CoeditingService coeditingService;

    @GetMapping(value={"/{objectType}/{objectId}/locks"})
    @Secured(value={"users"})
    @Operation(summary="Retrieve object lock holders", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public List<String> getLockHolders(@Parameter(description="Object Type: navigation, page layout ...") @PathVariable(value="objectType") String objectType, @Parameter(description="Object Type's specific element identifier") @PathVariable(value="objectId") String objectId) {
        return this.coeditingService.getLockHolders(new CoeditionObjectKey(objectType, objectId));
    }

    @PostMapping(value={"/{objectType}/{objectId}"}, consumes={"application/x-www-form-urlencoded"})
    @Secured(value={"users"})
    @Operation(summary="Set a lock on current object being edited", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public void setLock(HttpServletRequest request, @Parameter(description="Object Type: navigation, page layout ...") @PathVariable(value="objectType") String objectType, @Parameter(description="Object Type's specific element identifier") @PathVariable(value="objectId") String objectId, @Parameter(description="Current revision being edited by current user") @RequestParam(value="revision") String revision) {
        this.coeditingService.setLock(request.getRemoteUser(), new CoeditionObjectKey(objectType, objectId), revision);
    }

    @GetMapping(value={"/{objectType}/{objectId}"})
    @Secured(value={"users"})
    @Operation(summary="Retrieve object revision for current user", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public CoeditionObjectDraft getRevision(HttpServletRequest request, @Parameter(description="Object Type: navigation, page layout ...") @PathVariable(value="objectType") String objectType, @Parameter(description="Object Type's specific element identifier") @PathVariable(value="objectId") String objectId) {
        return this.coeditingService.getRevision(request.getRemoteUser(), new CoeditionObjectKey(objectType, objectId));
    }

    @DeleteMapping(value={"/{objectType}/{objectId}"})
    @Secured(value={"users"})
    @Operation(summary="Delete object revision for current user", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public void removeRevision(HttpServletRequest request, @Parameter(description="Object Type: navigation, page layout ...") @PathVariable(value="objectType") String objectType, @Parameter(description="Object Type's specific element identifier") @PathVariable(value="objectId") String objectId) {
        this.coeditingService.removeRevision(request.getRemoteUser(), new CoeditionObjectKey(objectType, objectId));
    }
}

