/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.storage;

import io.meeds.social.navigation.constant.SidebarMode;
import io.meeds.social.navigation.constant.TopbarItemType;
import io.meeds.social.navigation.model.NavigationConfiguration;
import io.meeds.social.navigation.model.TopbarApplication;
import io.meeds.social.util.JsonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NavigationConfigurationStorage {
    private static final String SETTING_KEY = "configuration";
    private static final String SETTING_USER_MODE_KEY = "sidebarMode";
    private static final Context SETTING_GLOBAL_CONTEXT = Context.GLOBAL.id("NavigationConfiguration");
    private static final Scope SETTING_SCOPE = Scope.APPLICATION.id("NavigationConfiguration");
    private static final NavigationConfiguration NULL_VALUE = new NavigationConfiguration();
    @Autowired
    private SettingService settingService;
    private NavigationConfiguration navigationConfiguration;

    public NavigationConfiguration getConfiguration(List<TopbarApplication> defaultApplications) {
        if (this.navigationConfiguration == null) {
            this.navigationConfiguration = this.retrieveNavigationConfiguration(defaultApplications);
        }
        return this.navigationConfiguration == NULL_VALUE ? null : this.navigationConfiguration.clone();
    }

    public void updateConfiguration(NavigationConfiguration navigationConfiguration) {
        try {
            this.settingService.set(SETTING_GLOBAL_CONTEXT, SETTING_SCOPE, SETTING_KEY, SettingValue.create((String)JsonUtils.toJsonString((Object)navigationConfiguration)));
        }
        finally {
            this.navigationConfiguration = null;
        }
    }

    public SidebarMode getSidebarUserMode(String username) {
        SettingValue settingValue = this.settingService.get(Context.USER.id(username), SETTING_SCOPE, SETTING_USER_MODE_KEY);
        return settingValue == null || settingValue.getValue() == null ? null : SidebarMode.valueOf((String)settingValue.getValue().toString());
    }

    public void updateSidebarUserMode(String username, SidebarMode mode) {
        this.settingService.set(Context.USER.id(username), SETTING_SCOPE, SETTING_USER_MODE_KEY, SettingValue.create((String)mode.name()));
    }

    private NavigationConfiguration retrieveNavigationConfiguration(List<TopbarApplication> defaultApplications) {
        SettingValue settingValue = this.settingService.get(SETTING_GLOBAL_CONTEXT, SETTING_SCOPE, SETTING_KEY);
        if (settingValue == null || settingValue.getValue() == null) {
            return NULL_VALUE;
        }
        NavigationConfiguration configuration = (NavigationConfiguration)JsonUtils.fromJsonString((String)settingValue.getValue().toString(), NavigationConfiguration.class);
        if (defaultApplications == null) {
            defaultApplications = Collections.emptyList();
        }
        this.addMissingTopbarApplication(configuration, defaultApplications);
        this.removeDroppedApplications(configuration, defaultApplications);
        this.updateApplicationIds(configuration, defaultApplications);
        return configuration;
    }

    private void removeDroppedApplications(NavigationConfiguration configuration, List<TopbarApplication> addonContainerApplications) {
        List topbarApplications = configuration.getTopbar().getApplications();
        List<TopbarApplication> topbarApplicationsToRemove = topbarApplications.stream().filter(topbarApp -> topbarApp.getType() == TopbarItemType.APP && addonContainerApplications.stream().noneMatch(containerApp -> Objects.equals(containerApp, topbarApp))).toList();
        if (CollectionUtils.isNotEmpty(topbarApplicationsToRemove)) {
            ArrayList mergedApplications = new ArrayList(topbarApplications);
            mergedApplications.removeAll(topbarApplicationsToRemove);
            configuration.getTopbar().setApplications(mergedApplications);
        }
    }

    private void addMissingTopbarApplication(NavigationConfiguration configuration, List<TopbarApplication> addonContainerApplications) {
        List topbarApplications = configuration.getTopbar().getApplications();
        List<TopbarApplication> topbarApplicationsToAdd = addonContainerApplications.stream().filter(containerApp -> topbarApplications.stream().noneMatch(topbarApp -> Objects.equals(containerApp, topbarApp))).toList();
        if (CollectionUtils.isNotEmpty(topbarApplicationsToAdd)) {
            ArrayList<TopbarApplication> mergedApplications = new ArrayList<TopbarApplication>(topbarApplications);
            mergedApplications.addAll(topbarApplicationsToAdd);
            configuration.getTopbar().setApplications(mergedApplications);
        }
    }

    private void updateApplicationIds(NavigationConfiguration configuration, List<TopbarApplication> defaultApplications) {
        defaultApplications.forEach(defaultApp -> {
            List topbarApplications = configuration.getTopbar().getApplications();
            TopbarApplication application = topbarApplications.stream().filter(topbarApplication -> Objects.equals(topbarApplication, defaultApp)).findFirst().orElse(null);
            if (application != null) {
                application.setId(defaultApp.getId());
            }
        });
    }
}

