/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.observe.plugin;

import io.meeds.social.observe.model.ObserverObject;
import io.meeds.social.observe.plugin.ObserverPlugin;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;

public class ActivityOberverPlugin
extends ObserverPlugin {
    public static final String OBJECT_TYPE = "activity";
    private static final String ACTIVITY_WITH_ID_NOT_FOUND = "Activity with id  %s doesn't exist";
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private IdentityRegistry identityRegistry;
    private OrganizationService organizationService;

    public ActivityOberverPlugin(ActivityManager activityManager, IdentityManager identityManager, OrganizationService organizationService, IdentityRegistry identityRegistry) {
        this.activityManager = activityManager;
        this.identityManager = identityManager;
        this.organizationService = organizationService;
        this.identityRegistry = identityRegistry;
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean canObserve(long identityId, String objectId) throws ObjectNotFoundException {
        ExoSocialActivity activity = this.activityManager.getActivity(objectId);
        if (activity == null) {
            throw new ObjectNotFoundException(String.format(ACTIVITY_WITH_ID_NOT_FOUND, objectId));
        }
        Identity identity = this.identityManager.getIdentity(String.valueOf(identityId));
        if (identity == null) {
            throw new ObjectNotFoundException(String.format("Identity with id  %s doesn't exist", identityId));
        }
        try {
            org.exoplatform.services.security.Identity aclIdentity = this.getIdentity(identity.getRemoteId());
            return this.activityManager.isActivityViewable(activity, aclIdentity);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error retrieving ACL identity of %s", identityId), e);
        }
    }

    public long getAudienceId(String objectId) throws ObjectNotFoundException {
        ExoSocialActivity activity = this.activityManager.getActivity(objectId);
        if (activity == null) {
            throw new ObjectNotFoundException(String.format(ACTIVITY_WITH_ID_NOT_FOUND, objectId));
        }
        return Long.parseLong(activity.getActivityStream().getId());
    }

    public long getSpaceId(String objectId) throws ObjectNotFoundException {
        ExoSocialActivity activity = this.activityManager.getActivity(objectId);
        if (activity == null) {
            throw new ObjectNotFoundException(String.format(ACTIVITY_WITH_ID_NOT_FOUND, objectId));
        }
        if (!activity.getActivityStream().isSpace()) {
            return 0L;
        }
        return Long.parseLong(activity.getSpaceId());
    }

    public ObserverObject getExtendedObserverObject(String objectId) throws ObjectNotFoundException {
        ExoSocialActivity activity = this.activityManager.getActivity(objectId);
        if (activity == null) {
            throw new ObjectNotFoundException(String.format(ACTIVITY_WITH_ID_NOT_FOUND, objectId));
        }
        if (activity.hasSpecificMetadataObject()) {
            return new ObserverObject(activity.getMetadataObject());
        }
        return super.getExtendedObserverObject(objectId);
    }

    private org.exoplatform.services.security.Identity getIdentity(String userId) throws Exception {
        org.exoplatform.services.security.Identity aclIdentity = this.identityRegistry.getIdentity(userId);
        if (aclIdentity == null) {
            List<MembershipEntry> entries = this.organizationService.getMembershipHandler().findMembershipsByUser(userId).stream().map(membership -> new MembershipEntry(membership.getGroupId(), membership.getMembershipType())).toList();
            aclIdentity = new org.exoplatform.services.security.Identity(userId, entries);
            this.identityRegistry.register(aclIdentity);
        }
        return aclIdentity;
    }
}

