/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.DownsampleConfig;
import co.elastic.clients.elasticsearch.indices.DownsampleResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

@JsonpDeserializable
public class DownsampleRequest
extends RequestBase
implements JsonpSerializable {
    private final String index;
    private final String targetIndex;
    private final DownsampleConfig config;
    public static final JsonpDeserializer<DownsampleRequest> _DESERIALIZER = DownsampleRequest.createDownsampleRequestDeserializer();
    public static final Endpoint<DownsampleRequest, DownsampleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DownsampleRequest, DownsampleResponse>("es/indices.downsample", request -> "POST", request -> {
        boolean _targetIndex = true;
        int _index = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_downsample");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.targetIndex, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _targetIndex = true;
        int _index = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("index", request.index);
            params.put("targetIndex", request.targetIndex);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, DownsampleResponse._DESERIALIZER);

    private DownsampleRequest(Builder builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.targetIndex = ApiTypeHelper.requireNonNull(builder.targetIndex, this, "targetIndex");
        this.config = ApiTypeHelper.requireNonNull(builder.config, this, "config");
    }

    public static DownsampleRequest of(Function<Builder, ObjectBuilder<DownsampleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    public final String targetIndex() {
        return this.targetIndex;
    }

    public final DownsampleConfig config() {
        return this.config;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.config.serialize(generator, mapper);
    }

    protected static JsonpDeserializer<DownsampleRequest> createDownsampleRequestDeserializer() {
        JsonpDeserializer<DownsampleConfig> valueDeserializer = DownsampleConfig._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().config((DownsampleConfig)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DownsampleRequest> {
        private String index;
        private String targetIndex;
        private DownsampleConfig config;

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder targetIndex(String value) {
            this.targetIndex = value;
            return this;
        }

        public final Builder config(DownsampleConfig value) {
            this.config = value;
            return this;
        }

        public final Builder config(Function<DownsampleConfig.Builder, ObjectBuilder<DownsampleConfig>> fn) {
            return this.config(fn.apply(new DownsampleConfig.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            DownsampleConfig value = DownsampleConfig._DESERIALIZER.deserialize(parser, mapper);
            return this.config(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DownsampleRequest build() {
            this._checkSingleUse();
            return new DownsampleRequest(this);
        }
    }
}

